/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla.apple;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;

public class AppleScript {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final String script;
    private final File scriptFile;
    private boolean deleteFile = false;

    public AppleScript(String string) {
        if (string == null) {
            throw new IllegalArgumentException("El script de entrada no puede ser nulo");
        }
        this.script = string;
        this.scriptFile = null;
    }

    public AppleScript(File file, boolean bl) {
        if (file == null) {
            throw new IllegalArgumentException("El fichero script de entrada no puede ser nulo");
        }
        this.script = null;
        this.scriptFile = file;
        this.deleteFile = false;
    }

    public String run() throws IOException, InterruptedException {
        return this.run(false);
    }

    public String runAsAdministrator() throws IOException, InterruptedException {
        return this.run(true);
    }

    private String run(boolean bl) throws IOException, InterruptedException {
        byte[] byArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("/usr/bin/osascript");
        arrayList.add("-e");
        String string = this.scriptFile != null ? this.scriptFile.getAbsolutePath() : this.script;
        String string2 = "do shell script \"" + string + "\"";
        if (bl) {
            string2 = string2 + " with administrator privileges";
        }
        arrayList.add(string2);
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        Process process = processBuilder.start();
        int n = process.waitFor();
        if (n != 0) {
            throw new IOException("La ejecucion del script devolvio el codigo de finalizacion: " + n);
        }
        try (InputStream inputStream = process.getInputStream();){
            byArray = AppleScript.readInputStream(inputStream);
        }
        if (this.deleteFile) {
            Files.delete(this.scriptFile.toPath());
        }
        return new String(byArray, DEFAULT_CHARSET);
    }

    private static byte[] readInputStream(InputStream inputStream) throws IOException {
        int n = 0;
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

