/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.BoundedBufferedReader;
import es.gob.afirma.keystores.mozilla.AOSecMod;
import es.gob.afirma.keystores.mozilla.shared.SharedNssUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public final class Pkcs11Txt {
    private static final String NAME_SEARCH_TOKEN = "name=\"";
    private static final String PKCS11TXT_FILENAME = "pkcs11.txt";

    private Pkcs11Txt() {
    }

    public static List<AOSecMod.ModuleName> getModules() throws IOException {
        File file = new File(SharedNssUtil.getSharedUserProfileDirectory() + File.separator + PKCS11TXT_FILENAME);
        if (!file.isFile()) {
            return new ArrayList<AOSecMod.ModuleName>(0);
        }
        if (!file.canRead()) {
            Logger.getLogger("es.gob.afirma").warning("No hay permisos de lectura para 'pkcs11.txt' en " + file.getAbsolutePath());
            return new ArrayList<AOSecMod.ModuleName>(0);
        }
        List<AOSecMod.ModuleName> list = Pkcs11Txt.getModules(file);
        return list;
    }

    static List<AOSecMod.ModuleName> getModules(File file) throws IOException {
        try (FileReader fileReader = new FileReader(file);){
            List<AOSecMod.ModuleName> list = Pkcs11Txt.getModules(fileReader);
            return list;
        }
    }

    static List<AOSecMod.ModuleName> getModules(Reader reader) throws IOException {
        ArrayList<AOSecMod.ModuleName> arrayList = new ArrayList<AOSecMod.ModuleName>();
        try (BoundedBufferedReader boundedBufferedReader = new BoundedBufferedReader(reader, 512, 4096);){
            String string;
            String string2 = null;
            String string3 = null;
            while ((string = ((BufferedReader)boundedBufferedReader).readLine()) != null) {
                if (string.trim().isEmpty()) {
                    string2 = null;
                    string3 = null;
                    continue;
                }
                String string4 = AOUtil.getRDNvalueFromLdapName("library", string.replace(" ", ","));
                if (string4 != null && !string4.trim().isEmpty()) {
                    if (string.contains(NAME_SEARCH_TOKEN)) {
                        arrayList.add(new AOSecMod.ModuleName(string4.trim(), string.substring(string.indexOf(NAME_SEARCH_TOKEN) + NAME_SEARCH_TOKEN.length(), string.indexOf(34, string.indexOf(NAME_SEARCH_TOKEN) + NAME_SEARCH_TOKEN.length()))));
                        string2 = null;
                        string3 = null;
                    } else {
                        string2 = string4.trim();
                    }
                } else if (string.startsWith("name=")) {
                    string3 = string.substring("name=".length()).trim();
                }
                if (string2 == null || string3 == null || string2.isEmpty() || string3.isEmpty()) continue;
                arrayList.add(new AOSecMod.ModuleName(string2, string3));
                string2 = null;
                string3 = null;
            }
        }
        return arrayList;
    }
}

