/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.misc.BoundedBufferedReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

final class NSPreferences {
    private NSPreferences() {
    }

    static String getFireFoxUserProfileDirectory(File file) throws IOException {
        FirefoxProfile[] firefoxProfileArray;
        if (file == null) {
            throw new IllegalArgumentException("El fichero INI es nulo y no se podra determinar el directorio del usuario de Firefox");
        }
        if (!file.exists() || !file.isFile()) {
            throw new IOException("No se ha encontrado el fichero con los perfiles de Firefox en: " + file);
        }
        String string = null;
        for (FirefoxProfile firefoxProfile : firefoxProfileArray = NSPreferences.readProfiles(file)) {
            if (!NSPreferences.isProfileLocked(firefoxProfile)) continue;
            string = firefoxProfile.getAbsolutePath();
            break;
        }
        if (string == null) {
            for (FirefoxProfile firefoxProfile : firefoxProfileArray) {
                if (!firefoxProfile.isDefault()) continue;
                string = firefoxProfile.getAbsolutePath();
                break;
            }
        }
        if (firefoxProfileArray.length > 0) {
            string = firefoxProfileArray[0].getAbsolutePath();
        }
        return string;
    }

    private static FirefoxProfile[] readProfiles(File file) throws IOException {
        String string = null;
        ArrayList<FirefoxProfile> arrayList = new ArrayList<FirefoxProfile>();
        try (BoundedBufferedReader boundedBufferedReader = new BoundedBufferedReader(new FileReader(file), 1024, 4096);){
            while ((string = ((BufferedReader)boundedBufferedReader).readLine()) != null) {
                if (!string.trim().toLowerCase().startsWith("[profile")) continue;
                FirefoxProfile firefoxProfile = new FirefoxProfile();
                while ((string = ((BufferedReader)boundedBufferedReader).readLine()) != null && string.trim().length() > 0 && !string.trim().toLowerCase().startsWith("[profile")) {
                    if (string.trim().toLowerCase().startsWith("name=")) {
                        firefoxProfile.setName(string.trim().substring("name=".length()));
                        continue;
                    }
                    if (string.trim().toLowerCase().startsWith("isrelative=")) {
                        firefoxProfile.setRelative(string.trim().substring("isrelative=".length()).equals("1"));
                        continue;
                    }
                    if (string.trim().toLowerCase().startsWith("path=")) {
                        firefoxProfile.setPath(string.trim().substring("path=".length()));
                        continue;
                    }
                    if (!string.trim().toLowerCase().startsWith("default=")) break;
                    firefoxProfile.setDefault(string.trim().substring("default=".length()).equals("1"));
                }
                if (firefoxProfile.getName() == null && firefoxProfile.getPath() == null) continue;
                firefoxProfile.setAbsolutePath(firefoxProfile.isRelative() ? new File(file.getParent(), firefoxProfile.getPath()).toString() : firefoxProfile.getPath());
                arrayList.add(firefoxProfile);
            }
        }
        return arrayList.toArray(new FirefoxProfile[arrayList.size()]);
    }

    private static boolean isProfileLocked(FirefoxProfile firefoxProfile) {
        return new File(firefoxProfile.getAbsolutePath(), "parent.lock").exists() || new File(firefoxProfile.getAbsolutePath(), "lock").exists();
    }

    static final class FirefoxProfile {
        private String name = null;
        private boolean relative = true;
        private String path = null;
        private String absolutePath = null;
        private boolean def = false;

        FirefoxProfile() {
        }

        String getName() {
            return this.name;
        }

        void setName(String string) {
            this.name = string;
        }

        boolean isRelative() {
            return this.relative;
        }

        void setRelative(boolean bl) {
            this.relative = bl;
        }

        String getPath() {
            return this.path;
        }

        void setPath(String string) {
            this.path = string;
        }

        String getAbsolutePath() {
            return this.absolutePath;
        }

        void setAbsolutePath(String string) {
            this.absolutePath = string;
        }

        boolean isDefault() {
            return this.def;
        }

        void setDefault(boolean bl) {
            this.def = bl;
        }
    }
}

