/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.AggregatedKeyStoreManager;
import es.gob.afirma.keystores.KeyStoreUtilities;
import es.gob.afirma.keystores.callbacks.UIPasswordCallback;
import es.gob.afirma.keystores.mozilla.FirefoxKeyStoreMessages;
import es.gob.afirma.keystores.mozilla.MozillaKeyStoreUtilities;
import es.gob.afirma.keystores.mozilla.NssKeyStoreManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.security.auth.callback.PasswordCallback;

public class MozillaUnifiedKeyStoreManager
extends AggregatedKeyStoreManager {
    private static final String ONLY_PKCS11 = "es.gob.afirma.keystores.mozilla.LoadSscdOnly";
    private static final String ONLY_PKCS11_ENV = "AFIRMA_NSS_LOAD_SSCD_ONLY";
    public static final String INCLUDE_NATIVE_DNIE_P11 = "es.gob.afirma.keystores.mozilla.IncludeNativeDniePkcs11";
    protected static final String INCLUDE_NATIVE_DNIE_P11_ENV = "AFIRMA_NSS_INCLUDE_NATIVE_DNIE_PKCS11";
    private PasswordCallback passwordCallback = null;
    private Object[] configParams = null;
    private boolean initialized = false;
    private boolean preferredKsAdded = false;

    public MozillaUnifiedKeyStoreManager() {
        this.setKeyStoreType(AOKeyStore.MOZ_UNI);
    }

    @Override
    public final void init(AOKeyStore aOKeyStore, InputStream inputStream, PasswordCallback passwordCallback, Object[] objectArray, boolean bl) {
        Object object;
        this.passwordCallback = passwordCallback;
        this.configParams = objectArray;
        this.removeAll();
        Object object2 = object = objectArray != null && objectArray.length > 0 ? objectArray[0] : null;
        if (!Boolean.getBoolean(ONLY_PKCS11) && !Boolean.parseBoolean(System.getenv(ONLY_PKCS11_ENV))) {
            AOKeyStoreManager aOKeyStoreManager = this.getNssKeyStoreManager();
            try {
                aOKeyStoreManager.init(aOKeyStore, inputStream, passwordCallback, objectArray, bl);
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido cargar NSS, se continuara con los almacenes externos: " + exception);
            }
            this.setKeyStore(aOKeyStoreManager.getKeyStore());
            this.addKeyStoreManager(aOKeyStoreManager);
        }
        boolean bl2 = false;
        if (bl || !this.initialized) {
            try {
                this.preferredKsAdded = KeyStoreUtilities.addPreferredKeyStoreManagers(this, object);
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                LOGGER.info("Se cancelo el uso del driver Java: " + aOCancelledOperationException);
                this.preferredKsAdded = false;
                bl2 = true;
            }
        }
        if (!this.preferredKsAdded) {
            Map<String, String> map = this.getExternalStores(bl2);
            if (map.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder("Encontrados los siguientes modulos PKCS#11 externos instalados en Mozilla / Firefox: ");
                for (String string : map.keySet()) {
                    stringBuilder.append("'");
                    stringBuilder.append(map.get(string));
                    stringBuilder.append("' ");
                }
                LOGGER.info(stringBuilder.toString());
            } else {
                LOGGER.info("No se han encontrado modulos PKCS#11 externos instalados en Firefox");
            }
            for (String string : map.keySet()) {
                AOKeyStoreManager aOKeyStoreManager = new AOKeyStoreManager();
                try {
                    MozillaUnifiedKeyStoreManager.internalInitStore(aOKeyStoreManager, string, object, bl, map.get(string));
                }
                catch (AOCancelledOperationException aOCancelledOperationException) {
                    LOGGER.warning("Se cancelo el acceso al almacen externo  '" + string + "', se continuara con el siguiente: " + aOCancelledOperationException);
                    continue;
                }
                catch (Exception exception) {
                    if (Platform.OS.LINUX.equals((Object)Platform.getOS())) {
                        try {
                            MozillaUnifiedKeyStoreManager.internalInitStore(aOKeyStoreManager, string, object, bl, map.get(string));
                        }
                        catch (AOCancelledOperationException aOCancelledOperationException) {
                            LOGGER.warning("Se cancelo el acceso al almacen externo  '" + string + "', se continuara con el siguiente: " + aOCancelledOperationException);
                            continue;
                        }
                        catch (Exception exception2) {
                            LOGGER.warning("No se ha podido inicializar el PKCS#11 '" + string + "' tras haberlo intentado dos veces: " + exception + ", " + exception2);
                            continue;
                        }
                    }
                    LOGGER.warning("No se ha podido inicializar el PKCS#11 '" + string + "': " + exception);
                    continue;
                }
                this.addKeyStoreManager(aOKeyStoreManager);
                LOGGER.info("El almacen externo '" + string + "' ha podido inicializarse, se anadiran sus entradas y se detiene la carga del resto de almacenes");
                break;
            }
        }
        if (this.lacksKeyStores()) {
            LOGGER.warning("No se ha podido inicializar ningun almacen, interno o externo, de Firefox, ni los almacenes preferentes");
        }
        this.initialized = true;
    }

    private static void internalInitStore(AOKeyStoreManager aOKeyStoreManager, String string, Object object, boolean bl, String string2) throws AOKeyStoreManagerException, IOException {
        aOKeyStoreManager.init(AOKeyStore.PKCS11, null, new UIPasswordCallback(FirefoxKeyStoreMessages.getString("MozillaUnifiedKeyStoreManager.1") + " " + string, object), new String[]{string2, string.toString()}, bl);
    }

    @Override
    public void refresh() throws IOException {
        this.init(AOKeyStore.MOZ_UNI, null, this.passwordCallback, this.configParams, true);
    }

    protected Map<String, String> getExternalStores() {
        return MozillaKeyStoreUtilities.getMozillaPKCS11Modules(!Platform.OS.LINUX.equals((Object)Platform.OS.LINUX) || Boolean.getBoolean("es.gob.afirma.keystores.mozilla.disableDnieNativeDriver") || Boolean.parseBoolean(System.getenv("AFIRMA_NSS_DISABLE_DNIE_NATIVE_DRIVER")), true);
    }

    protected Map<String, String> getExternalStores(boolean bl) {
        return MozillaKeyStoreUtilities.getMozillaPKCS11Modules(bl, true);
    }

    protected AOKeyStoreManager getNssKeyStoreManager() {
        return new NssKeyStoreManager(this.getParentComponent(), false);
    }
}

