/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.mozilla.BundledNssHelper;
import es.gob.afirma.keystores.mozilla.MozillaKeyStoreUtilities;
import es.gob.afirma.keystores.mozilla.bintutil.MsPortableExecutable;
import es.gob.afirma.keystores.mozilla.bintutil.PEParserException;
import es.gob.afirma.keystores.mozilla.bintutil.PeMachineType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

final class MozillaKeyStoreUtilitiesWindows {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String P11_CONFIG_VALID_CHARS = ":\\0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_.~";
    private static final String SOFTOKN3_DLL = "softokn3.dll";
    private static final String MSVCR100_DLL = "msvcr100.dll";
    private static final String MSVCP100_DLL = "msvcp100.dll";
    private static final String MSVCR120_DLL = "msvcr120.dll";
    private static final String MSVCP120_DLL = "msvcp120.dll";
    private static final String MSVCR140_DLL = "VCRUNTIME140.DLL";
    private static final String MSVCP140_DLL = "msvcp140.dll";
    private static final String PLC4_DLL = "plc4.dll";
    private static final String PLDS4_DLL = "plds4.dll";
    private static final String NSPR4_DLL = "nspr4.dll";
    private static final String MOZSQLITE3_DLL = "mozsqlite3.dll";
    private static final String MOZCRT19_DLL = "mozcrt19.dll";
    private static final String NSSUTIL3_DLL = "nssutil3.dll";
    private static final String FREEBL3_DLL = "freebl3.dll";
    private static final String NSSDBM3_DLL = "nssdbm3.dll";
    private static final String SQLITE3_DLL = "sqlite3.dll";
    private static final String MOZUTILS_DLL = "mozutils.dll";
    private static final String MOZGLUE_DLL = "mozglue.dll";
    private static final String NSS3_DLL = "nss3.dll";
    private static String appData = null;

    private MozillaKeyStoreUtilitiesWindows() {
    }

    static String getShort(String string) {
        if (string == null || !Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            return string;
        }
        File file = new File(string);
        if (!file.exists()) {
            return string;
        }
        try {
            Process process = new ProcessBuilder("cmd.exe", "/c", "for %f in (\"" + string + "\") do @echo %~sf").start();
            return new String(AOUtil.getDataFromInputStream(process.getInputStream())).trim();
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido obtener el nombre corto de " + string + ": " + exception);
            return string;
        }
    }

    static String cleanMozillaUserProfileDirectoryWindows(String string) {
        return MozillaKeyStoreUtilitiesWindows.getShort(string).replace('\\', '/');
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getSystemNSSLibDirWindows() throws IOException {
        Object object;
        String string = MozillaKeyStoreUtilitiesWindows.getShort(MozillaKeyStoreUtilities.getNssPathFromCompatibilityFile());
        if (string == null) {
            throw new FileNotFoundException("No se encuentra el directorio de NSS en Windows");
        }
        boolean bl = false;
        for (char c : string.toCharArray()) {
            if (P11_CONFIG_VALID_CHARS.indexOf(c) != -1) continue;
            bl = true;
            break;
        }
        if (bl) {
            LOGGER.info("La ruta hacia las bibliotecas NSS contiene carcateres ilegales, se copiaran a un temporal: " + string);
            try {
                File file = new File(new File(Platform.getSystemLibDir()).getParent(), "Temp");
                object = file.isDirectory() && file.canWrite() && file.canRead() ? File.createTempFile("nss", null, file) : File.createTempFile("nss", null);
                ((File)object).delete();
                if (!((File)object).mkdir()) {
                    throw new AOException("No se ha podido crear el directorio temporal para las bibliotecas NSS");
                }
                MozillaKeyStoreUtilitiesWindows.copyFile(new String[]{SOFTOKN3_DLL}, string, ((File)object).getCanonicalPath());
                MozillaKeyStoreUtilitiesWindows.copyFile(MozillaKeyStoreUtilitiesWindows.getSoftkn3DependenciesWindows(""), string, ((File)object).getCanonicalPath());
                string = ((File)object).getCanonicalPath();
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido duplicar NSS en un directorio temporal, si esta version de JRE esta afectada por el error 6581254 de Java es posible que no pueda cargarse: " + exception);
            }
        }
        if (string == null) throw new FileNotFoundException("No se ha encontrado un NSS compatible en Windows");
        object = new File(string, SOFTOKN3_DLL);
        if (!((File)object).exists()) throw new FileNotFoundException("No se ha encontrado un NSS en Windows para el directorio " + string);
        if (!((File)object).canRead()) {
            throw new FileNotFoundException("No se ha encontrado un NSS en Windows para el directorio " + string);
        }
        try (FileInputStream fileInputStream = new FileInputStream((File)object);){
            PeMachineType peMachineType = new MsPortableExecutable(AOUtil.getDataFromInputStream(fileInputStream)).getPeMachineType();
            String string3 = Platform.getJavaArch();
            if (peMachineType.equals((Object)PeMachineType.INTEL_386) && "32".equals(string3) || peMachineType.equals((Object)PeMachineType.X64) && "64".equals(string3)) {
                LOGGER.info("Arquitectura del NSS encontrado: " + (Object)((Object)peMachineType));
                return string;
            }
            LOGGER.info("Se usara un NSS local por ser este Java de " + string3 + " bits y el NSS de sistema para la arquitectura " + (Object)((Object)peMachineType));
            String string2 = BundledNssHelper.getBundledNssDirectory();
            return string2;
        }
        catch (PEParserException pEParserException) {
            LOGGER.warning("No se ha podido analizar la arquitectura del NSS encontrado: " + pEParserException);
        }
        return string;
    }

    static String[] getSoftkn3DependenciesWindows(String string) {
        return new String[]{string + MSVCR100_DLL, string + MSVCP100_DLL, string + MSVCR120_DLL, string + MSVCP120_DLL, string + MSVCR140_DLL, string + MSVCP140_DLL, string + MOZGLUE_DLL, string + NSS3_DLL, string + MOZUTILS_DLL, string + MOZCRT19_DLL, string + NSPR4_DLL, string + PLDS4_DLL, string + PLC4_DLL, string + NSSUTIL3_DLL, string + MOZSQLITE3_DLL, string + SQLITE3_DLL, string + NSSDBM3_DLL, string + FREEBL3_DLL};
    }

    static String getWindowsAppDataDir() {
        String string;
        if (appData == null && (string = System.getenv("AppData")) != null) {
            LOGGER.info("Se ha comprobado la situacion del directorio 'AppData' de Windows a traves de la variable de entorno");
            appData = string;
        }
        if (appData != null) {
            return appData;
        }
        string = "C:\\Users\\" + System.getProperty("user.name") + "\\AppData\\Roaming";
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            appData = string;
            LOGGER.info("Se ha comprobado la situacion del directorio 'AppData' de Windows manualmente");
            return appData;
        }
        appData = null;
        throw new IllegalStateException("No se ha podido determinar la situacion del directorio 'AppData' de Windows");
    }

    private static void copyFile(String[] stringArray, String string, String string2) {
        if (stringArray != null) {
            for (String string3 : stringArray) {
                File file = new File(string, string3);
                if (!file.exists()) continue;
                try {
                    AOUtil.copyFile(file, new File(string2, string3));
                }
                catch (IOException iOException) {
                    LOGGER.warning("No se ha podido copiar '" + string3 + "' a '" + string2 + "': " + iOException);
                }
            }
        }
    }
}

