/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Logger;

final class MozillaKeyStoreUtilitiesUnix {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String SOFTOKN3_SO = "libsoftokn3.so";
    private static final String[] NSS_PATHS = new String[]{"/usr/lib/x86_64-linux-gnu/nss", "/usr/lib/x86_64-linux-gnu/", "/usr/lib/firefox", "/usr/lib/firefox-" + MozillaKeyStoreUtilitiesUnix.searchLastFirefoxVersion("/usr/lib/"), "/opt/firefox", "/opt/firefox-" + MozillaKeyStoreUtilitiesUnix.searchLastFirefoxVersion("/opt/"), "/lib", "/usr/lib64", "/usr/lib", "/usr/lib/nss", "/usr/lib/i386-linux-gnu/nss", "/usr/lib/i386-linux-gnu", "/opt/fedora-ds/clients/lib", "/opt/google/chrome", "/usr/lib/thunderbird", "/usr/lib64"};
    private static final String[] SQLITE_LIBS = new String[]{"mozsqlite3.so", "libmozsqlite3.so", "libsqlite3.so.0", "libnspr4.so"};

    private MozillaKeyStoreUtilitiesUnix() {
    }

    static String getNSSLibDirUnix() throws FileNotFoundException {
        String string = null;
        for (String string2 : NSS_PATHS) {
            if (!new File(string2, SOFTOKN3_SO).exists()) continue;
            string = string2;
        }
        if (string == null) {
            throw new FileNotFoundException("No se ha podido determinar la localizacion de NSS en UNIX");
        }
        for (String string2 : NSS_PATHS) {
            File file = new File(string2);
            for (String string3 : SQLITE_LIBS) {
                File file2 = new File(file, string3);
                if (!file2.exists()) continue;
                try {
                    System.load(file2.getAbsolutePath());
                    return string;
                }
                catch (Exception exception) {
                    LOGGER.warning("Descartamos el NSS situado en '" + string2 + "' porque no puede cargarse adecuadamente: " + exception);
                }
            }
        }
        throw new FileNotFoundException("No se ha podido determinar la localizacion de NSS en UNIX (sqlite)");
    }

    private static String searchLastFirefoxVersion(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    if (!string2.startsWith("firefox-")) continue;
                    arrayList.add(string2.replace("firefox-", ""));
                }
            }
            if (arrayList.isEmpty()) {
                return "";
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    Integer.getInteger((String)arrayList.get(i));
                    continue;
                }
                catch (Exception exception) {
                    arrayList.remove(i);
                }
            }
            if (arrayList.size() == 1) {
                return (String)arrayList.get(0);
            }
            Collections.sort(arrayList, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return string.compareTo(string2);
                }
            });
            return (String)arrayList.get(0);
        }
        return "";
    }
}

