/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.mozilla.apple.AppleScript;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MozillaKeyStoreUtilitiesOsX {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String LIBRARY_FOLDER = "/usr/local/lib";

    private MozillaKeyStoreUtilitiesOsX() {
    }

    public static void configureMacNSS(String string) throws AOException {
        if (!Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            return;
        }
        if (string == null) {
            LOGGER.severe("El directorio de NSS para configurar proporcionado es nulo, no se realizara ninguna accion");
            return;
        }
        String string2 = string.endsWith("/") ? string : string + "/";
        try {
            System.load(string2 + "libsoftokn3.dylib");
            return;
        }
        catch (Exception exception) {
            LOGGER.warning("No se puede realizar una carga directa de NSS, se crearan enlaces simbolicos: " + exception);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            LOGGER.warning("No se puede realizar una carga directa de NSS, se crearan enlaces simbolicos: " + unsatisfiedLinkError);
        }
        String[] stringArray = new String[]{"libmozglue.dylib", "libmozutils.dylib", "libnspr4.dylib", "libplds4.dylib", "libplc4.dylib", "libnssutil3.dylib", "libmozsqlite3.dylib", "libnss3.dylib"};
        StringBuilder stringBuilder = new StringBuilder();
        if (!new File(LIBRARY_FOLDER).exists()) {
            stringBuilder.append("mkdir ").append(LIBRARY_FOLDER).append("; ");
        }
        for (String string3 : stringArray) {
            if (!new File(string2 + string3).exists()) continue;
            stringBuilder.append("ln -s ");
            stringBuilder.append(string2);
            stringBuilder.append(string3);
            stringBuilder.append(" ");
            stringBuilder.append(LIBRARY_FOLDER);
            stringBuilder.append(File.separator);
            stringBuilder.append(string3);
            stringBuilder.append("; ");
        }
        try {
            AppleScript appleScript = new AppleScript(stringBuilder.toString());
            appleScript.runAsAdministrator();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "No se han podido crear los enlaces simbolicos para NSS: " + exception, exception);
            LOGGER.severe("Fallo en el script: " + stringBuilder.toString());
        }
        try {
            System.load(string2 + "libsoftokn3.dylib");
        }
        catch (Exception exception) {
            throw new AOException("La configuracion de NSS para Mac OS X ha fallado por motivos de seguridad: " + exception);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new AOException("La configuracion de NSS para Mac OS X ha fallado: " + unsatisfiedLinkError);
        }
    }

    static String getSystemNSSLibDirMacOsX() throws FileNotFoundException {
        String[] stringArray = new String[]{"/Applications/Firefox.app/Contents/MacOS", "/lib", "/usr/lib", "/usr/lib/nss", "/Applications/Minefield.app/Contents/MacOS"};
        String string = null;
        for (String string2 : stringArray) {
            if (!new File(string2 + "/libsoftokn3.dylib").exists()) continue;
            string = string2;
            break;
        }
        if (string == null) {
            throw new FileNotFoundException("No se ha podido determinar la localizacion de NSS en Mac OS X");
        }
        return string;
    }
}

