/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.BoundedBufferedReader;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.mozilla.AOSecMod;
import es.gob.afirma.keystores.mozilla.MozillaKeyStoreUtilitiesOsX;
import es.gob.afirma.keystores.mozilla.MozillaKeyStoreUtilitiesUnix;
import es.gob.afirma.keystores.mozilla.MozillaKeyStoreUtilitiesWindows;
import es.gob.afirma.keystores.mozilla.NSPreferences;
import es.gob.afirma.keystores.mozilla.Pkcs11Txt;
import es.gob.afirma.keystores.mozilla.shared.SharedNssUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MozillaKeyStoreUtilities {
    private static final String SUN_PKCS11_PROVIDER_CLASSNAME = "sun.security.pkcs11.SunPKCS11";
    private static final String LIB_NSPR4_SO = "/lib/libnspr4.so";
    private static final String SOFTOKN3_SO = "libsoftokn3.so";
    private static final String SOFTOKN3_DLL = "softokn3.dll";
    private static final String PKCS11TXT_FILENAME = "pkcs11.txt";
    private static final String AFIRMA_NSS_HOME_ENV = "AFIRMA_NSS_HOME_ENV";
    private static final String AFIRMA_NSS_PROFILES_INI = "AFIRMA_NSS_PROFILES_INI";
    private static final String USE_ENV_VARS = "es.gob.afirma.keystores.mozilla.UseEnvironmentVariables";
    public static final String ENABLE_NSS_WRITE = "es.gob.afirma.keystores.mozilla.EnableNssWrite";
    private static final String[] DNI_P11_NAMES = new String[]{"libopensc-dnie.dylib", "libpkcs11-dnie.so", "usrpkcs11.dll", "dnie_p11_priv.dll", "dnie_p11_pub.dll", "opensc-pkcs11.dll", "DNIE_P11.dll", "TIF_P11.dll"};
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static String nssLibDir = null;

    private MozillaKeyStoreUtilities() {
    }

    static String createPKCS11NSSConfigFile(String string, String string2) {
        String string3 = Platform.getOS().equals((Object)Platform.OS.WINDOWS) ? SOFTOKN3_DLL : (Platform.getOS().equals((Object)Platform.OS.MACOSX) ? "libsoftokn3.dylib" : SOFTOKN3_SO);
        StringBuilder stringBuilder = new StringBuilder("name=NSSCrypto-AFirma\r\n");
        stringBuilder.append("library=").append(string2).append(File.separator).append(string3).append("\n").append("attributes=compatibility\n").append("slot=2\n").append("showInfo=false\n").append("allowSingleThreadedModules=true\n").append("nssArgs=\"").append("configdir='").append(string).append("' ").append("certPrefix='' ").append("keyPrefix='' ").append(Boolean.getBoolean(ENABLE_NSS_WRITE) ? "" : "flags='readOnly'").append("\"");
        return stringBuilder.toString();
    }

    static String getNssPathFromCompatibilityFile() throws IOException {
        File file = new File(MozillaKeyStoreUtilities.getMozillaUserProfileDirectory(), "compatibility.ini");
        String string = null;
        if (file.exists() && file.canRead()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);
                 BoundedBufferedReader boundedBufferedReader = new BoundedBufferedReader(new InputStreamReader(fileInputStream), 512, 4096);){
                String string2;
                while ((string2 = ((BufferedReader)boundedBufferedReader).readLine()) != null && string == null) {
                    if (!string2.startsWith("LastPlatformDir=")) continue;
                    string = string2.replace("LastPlatformDir=", "").trim();
                }
            }
        }
        if (string == null) {
            throw new FileNotFoundException("No se ha podido determinar el directorio de NSS en Windows a partir de 'compatibility.ini' de Firefox");
        }
        return string;
    }

    public static String getSystemNSSLibDir() throws IOException {
        if (nssLibDir != null) {
            return nssLibDir;
        }
        if (Boolean.getBoolean(USE_ENV_VARS)) {
            try {
                nssLibDir = System.getenv(AFIRMA_NSS_HOME_ENV);
            }
            catch (Exception exception) {
                LOGGER.warning("No se tiene acceso a la variable de entorno 'AFIRMA_NSS_HOME_ENV': " + exception);
            }
            if (nssLibDir != null) {
                File file = new File(nssLibDir);
                if (file.isDirectory() && file.canRead()) {
                    LOGGER.info("Directorio de NSS determinado a partir de la variable de entorno 'AFIRMA_NSS_HOME_ENV'");
                } else {
                    LOGGER.warning("La variable de entorno 'AFIRMA_NSS_HOME_ENV' apunta a un directorio que no existe o sobre el que no se tienen permisos de lectura, se ignorara");
                    nssLibDir = null;
                }
            }
        }
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            nssLibDir = MozillaKeyStoreUtilitiesWindows.getSystemNSSLibDirWindows();
        } else if (Platform.getOS().equals((Object)Platform.OS.LINUX) || Platform.getOS().equals((Object)Platform.OS.SOLARIS)) {
            nssLibDir = MozillaKeyStoreUtilitiesUnix.getNSSLibDirUnix();
        } else if (Platform.getOS().equals((Object)Platform.OS.MACOSX)) {
            nssLibDir = MozillaKeyStoreUtilitiesOsX.getSystemNSSLibDirMacOsX();
        }
        if (nssLibDir == null) {
            throw new FileNotFoundException("No se han encontrado bibliotecas NSS instaladas en su sistema operativo");
        }
        return nssLibDir;
    }

    static Map<String, String> getMozillaPKCS11Modules(boolean bl, boolean bl2) {
        String string;
        if (!bl) {
            LOGGER.info("Se incluiran los modulos nativos de DNIe/CERES si se encuentran configurados");
        } else {
            LOGGER.info("Se excluiran los modulos nativos de DNIe/CERES en favor del controlador 100% Java");
        }
        try {
            string = MozillaKeyStoreUtilities.getMozillaUserProfileDirectory();
        }
        catch (IOException iOException) {
            LOGGER.severe("No se ha podido obtener el directorio de perfil de Mozilla para leer la lista de modulos PKCS#11: " + iOException);
            return new ConcurrentHashMap<String, String>(0);
        }
        File file = new File(string, PKCS11TXT_FILENAME);
        if ("sql".equals(System.getenv("NSS_DEFAULT_DB_TYPE")) || file.exists()) {
            try {
                List<AOSecMod.ModuleName> list = Pkcs11Txt.getModules(file);
                LOGGER.info("Obtenidos los modulos externos de Mozilla desde 'pkcs11.txt'");
                return MozillaKeyStoreUtilities.getPkcs11ModulesFromModuleNames(list, bl2, bl);
            }
            catch (IOException iOException) {
                LOGGER.severe("No se han podido obtener los modulos externos de Mozilla desde 'pkcs11.txt': " + iOException);
            }
        }
        try {
            List<AOSecMod.ModuleName> list = AOSecMod.getModules(string);
            LOGGER.info("Obtenidos los modulos externos de Mozilla desde 'secmod.db'");
            return MozillaKeyStoreUtilities.getPkcs11ModulesFromModuleNames(list, bl2, bl);
        }
        catch (Exception exception) {
            LOGGER.severe("No se han podido obtener los modulos externos de Mozilla desde 'secmod.db': " + exception);
            return new ConcurrentHashMap<String, String>(0);
        }
    }

    public static Map<String, String> getPkcs11ModulesFromModuleNames(List<AOSecMod.ModuleName> list, boolean bl, boolean bl2) {
        if (list == null) {
            return new ConcurrentHashMap<String, String>(0);
        }
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        for (AOSecMod.ModuleName knownModuleArray : list) {
            String string = knownModuleArray.getLib();
            if (bl2 && MozillaKeyStoreUtilities.isDniePkcs11Library(string)) continue;
            concurrentHashMap.put(knownModuleArray.getDescription(), string);
        }
        ConcurrentHashMap concurrentHashMap2 = new ConcurrentHashMap(concurrentHashMap.size());
        concurrentHashMap2.putAll(concurrentHashMap);
        if (bl) {
            for (KnownModule knownModule : KnownModule.values()) {
                if (!Platform.getOS().equals((Object)knownModule.getOs()) || bl2 && MozillaKeyStoreUtilities.isDniePkcs11Library(knownModule.getLib()) || MozillaKeyStoreUtilities.isModuleIncluded(concurrentHashMap2, knownModule.getLib())) continue;
                String string = MozillaKeyStoreUtilities.getWindowsSystemDirWithFinalSlash() + knownModule.getLib();
                if (!knownModule.isForcedLoad() && !new File(string).exists()) continue;
                concurrentHashMap.put(knownModule.getDescription(), string);
            }
        }
        return MozillaKeyStoreUtilities.purgeStoresTable(concurrentHashMap);
    }

    static void loadNSSDependencies(String string) {
        String[] stringArray;
        if (Platform.OS.LINUX.equals((Object)Platform.getOS()) && new File("/usr/lib/libsoftokn3.so").exists() && new File(LIB_NSPR4_SO).exists()) {
            stringArray = new String[]{"/lib/libmozglue.so", "/usr/lib/libmozglue.so", LIB_NSPR4_SO, "/lib/libplds4.so", "/usr/lib/libplds4.so", "/lib/libplc4.so", "/usr/lib/libplc4.so", "/lib/libnssutil3.so", "/usr/lib/libnssutil3.so", "/lib/libsqlite3.so", "/usr/lib/libsqlite3.so", "/lib/libmozsqlite3.so", "/usr/lib/libmozsqlite3.so"};
        } else {
            String[] stringArray2 = string + (string.endsWith(File.separator) ? "" : File.separator);
            stringArray = MozillaKeyStoreUtilities.getSoftkn3Dependencies((String)stringArray2);
        }
        for (String string2 : stringArray) {
            if (!new File(string2).exists()) continue;
            try {
                System.load(string2);
            }
            catch (Error error) {
                LOGGER.log(Level.WARNING, "Error al cargar la biblioteca " + string2 + " para el acceso al almacen de claves de Mozilla: " + error, error);
            }
        }
    }

    private static String[] getSoftkn3Dependencies(String string) {
        String string2;
        if (string == null) {
            return new String[0];
        }
        if (Platform.getOS().equals((Object)Platform.OS.MACOSX)) {
            return new String[0];
        }
        String string3 = string2 = !string.endsWith(File.separator) ? string + File.separator : string;
        if (Platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return MozillaKeyStoreUtilitiesWindows.getSoftkn3DependenciesWindows(string2);
        }
        if (Platform.getOS().equals((Object)Platform.OS.LINUX) || Platform.getOS().equals((Object)Platform.OS.SOLARIS)) {
            return new String[]{string2 + "libnspr4.so", string2 + "libplds4.so", string2 + "libplc4.so", string2 + "libnssutil3.so", string2 + "libsqlite3.so", string2 + "libmozsqlite3.so", string2 + "libsqlite3.so.0"};
        }
        LOGGER.warning("Plataforma no soportada para la precarga de las bibliotecas NSS: " + (Object)((Object)Platform.getOS()));
        return new String[0];
    }

    private static String getProfilesIniPath() {
        String string = null;
        if (Boolean.getBoolean(USE_ENV_VARS) || Boolean.parseBoolean(System.getenv(USE_ENV_VARS))) {
            try {
                string = System.getenv(AFIRMA_NSS_PROFILES_INI);
                if (string == null) {
                    string = System.getProperty(AFIRMA_NSS_PROFILES_INI);
                }
            }
            catch (Exception exception) {
                LOGGER.warning("No se tiene acceso a la variable de entorno 'AFIRMA_NSS_PROFILES_INI': " + exception);
            }
            if (string != null) {
                File file;
                int n = string.toUpperCase().indexOf("%APPDATA%");
                if (n != -1) {
                    string = string.replace(string.substring(n, n + "%APPDATA%".length()), MozillaKeyStoreUtilitiesWindows.getWindowsAppDataDir());
                }
                if ((file = new File(string)).isFile() && file.canRead()) {
                    LOGGER.info("Fichero de perfiles de Firefox determinado a partir de la variable de entorno 'AFIRMA_NSS_PROFILES_INI'");
                    return string;
                }
                LOGGER.warning("La variable de entorno 'AFIRMA_NSS_PROFILES_INI' apunta a un fichero que no existe o sobre el que no se tienen permisos de lectura, se ignorara: " + string);
            }
        }
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            return MozillaKeyStoreUtilitiesWindows.getWindowsAppDataDir() + "\\Mozilla\\Firefox\\profiles.ini";
        }
        if (Platform.getOS().equals((Object)Platform.OS.MACOSX)) {
            return Platform.getUserHome() + "/Library/Application Support/Firefox/profiles.ini";
        }
        return Platform.getUserHome() + "/.mozilla/firefox/profiles.ini";
    }

    public static String getMozillaUserProfileDirectory() throws IOException {
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            return MozillaKeyStoreUtilities.getMozillaUserProfileDirectoryWindows(MozillaKeyStoreUtilities.getProfilesIniPath());
        }
        try {
            return NSPreferences.getFireFoxUserProfileDirectory(new File(MozillaKeyStoreUtilities.getProfilesIniPath()));
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "No ha podido determinarse el perfil de usuario de Mozilla, se intentara usar el global: " + exception, exception);
            return SharedNssUtil.getSharedUserProfileDirectory();
        }
    }

    public static String getMozillaUserProfileDirectoryWindows(String string) throws IOException {
        String string2 = NSPreferences.getFireFoxUserProfileDirectory(new File(string));
        return MozillaKeyStoreUtilitiesWindows.cleanMozillaUserProfileDirectoryWindows(string2);
    }

    private static Provider loadNssJava9(String string, String string2) throws IOException, AOException {
        Provider provider = Security.getProvider("SunPKCS11");
        File file = File.createTempFile("pkcs11_nss_", ".cfg");
        Object object = new FileOutputStream(file);
        Object object2 = null;
        try {
            ((OutputStream)object).write(string2.getBytes());
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((OutputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((OutputStream)object).close();
                }
            }
        }
        try {
            object2 = Provider.class.getMethod("configure", String.class);
            object = (Provider)((Method)object2).invoke((Object)provider, file.getAbsolutePath());
        }
        catch (Exception exception) {
            LOGGER.warning("NSS no se ha podido iniciar sin precargar sus dependencias: " + exception);
            if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
                MozillaKeyStoreUtilitiesOsX.configureMacNSS(string);
            } else {
                MozillaKeyStoreUtilities.loadNSSDependencies(string);
            }
            try {
                Method method = Provider.class.getMethod("configure", String.class);
                object = (Provider)method.invoke((Object)provider, file.getAbsolutePath());
            }
            catch (Exception exception2) {
                LOGGER.info("No se ha podido cargar NSS en modo SQLite, se intentara en modo Berkeley: " + exception2);
                try (Object object3 = new FileOutputStream(file);){
                    ((OutputStream)object3).write(string2.replace("sql:/", "").getBytes());
                }
                try {
                    object3 = Provider.class.getMethod("configure", String.class);
                    object = (Provider)((Method)object3).invoke((Object)provider, file.getAbsolutePath());
                }
                catch (Exception exception3) {
                    throw new AOException("Ocurrio un error al configurar el proveedor de acceso a NSS", exception3);
                }
            }
        }
        file.delete();
        return object;
    }

    private static Provider loadNssJava8(String string, String string2) throws AOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        try {
            return (Provider)Class.forName(SUN_PKCS11_PROVIDER_CLASSNAME).getConstructor(InputStream.class).newInstance(new ByteArrayInputStream(string2.getBytes()));
        }
        catch (Exception exception) {
            LOGGER.info("NSS necesita una precarga o tratamiento de sus dependencias: " + exception);
            if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
                MozillaKeyStoreUtilitiesOsX.configureMacNSS(string);
            } else {
                MozillaKeyStoreUtilities.loadNSSDependencies(string);
            }
            try {
                return (Provider)Class.forName(SUN_PKCS11_PROVIDER_CLASSNAME).getConstructor(InputStream.class).newInstance(new ByteArrayInputStream(string2.getBytes()));
            }
            catch (Exception exception2) {
                LOGGER.warning("Ha fallado el segundo intento de carga de NSS: " + exception2);
                return (Provider)Class.forName(SUN_PKCS11_PROVIDER_CLASSNAME).getConstructor(InputStream.class).newInstance(new ByteArrayInputStream(string2.replace("sql:/", "").getBytes()));
            }
        }
    }

    static Provider loadNSS(boolean bl) throws IOException, AOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        String string = MozillaKeyStoreUtilities.getSystemNSSLibDir();
        String string2 = bl ? SharedNssUtil.getSharedUserProfileDirectory() : MozillaKeyStoreUtilities.getMozillaUserProfileDirectory();
        try {
            if ("sql".equals(System.getenv("NSS_DEFAULT_DB_TYPE")) || new File(string2, PKCS11TXT_FILENAME).exists()) {
                string2 = "sql:/" + string2;
            }
        }
        catch (Exception exception) {
            LOGGER.warning("No se pudo comprobar si el almacen de claves debia cargase como base de datos: " + exception);
        }
        String string3 = MozillaKeyStoreUtilities.createPKCS11NSSConfigFile(string2, string);
        LOGGER.info("Configuracion de NSS para SunPKCS11:\n" + string3.replace(Platform.getUserHome(), "USERHOME"));
        Provider provider = AOUtil.isJava9orNewer() ? MozillaKeyStoreUtilities.loadNssJava9(string, string3) : MozillaKeyStoreUtilities.loadNssJava8(string, string3);
        Security.addProvider(provider);
        LOGGER.info("Proveedor PKCS#11 para NSS anadido" + (bl ? " para perfil compartido" : "") + ": " + provider.getName());
        return provider;
    }

    private static boolean isDniePkcs11Library(String string) {
        if (string == null || Boolean.getBoolean("es.gob.afirma.keystores.mozilla.disableDnieNativeDriver")) {
            return false;
        }
        for (String string2 : DNI_P11_NAMES) {
            if (!string.toLowerCase().endsWith(string2.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static String getWindowsSystemDirWithFinalSlash() {
        if (!Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            return "";
        }
        String string = System.getenv("SystemRoot");
        if (string == null) {
            return "";
        }
        if ("64".equals(Platform.getJavaArch())) {
            return string + "\\System32\\";
        }
        if (new File(string + "\\SysWOW64\\").exists()) {
            return string + "\\SysWOW64\\";
        }
        return string + "\\System32\\";
    }

    private static boolean isModuleIncluded(Map<String, String> map, String string) {
        if (map == null || string == null) {
            throw new IllegalArgumentException("Ni la lista de almacenes ni el modulo a comprobar pueden ser nulos");
        }
        for (String string2 : map.keySet()) {
            if (!map.get(string2).toLowerCase().endsWith(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> purgeStoresTable(Map<String, String> map) {
        String[] stringArray;
        if (map == null) {
            return new ConcurrentHashMap<String, String>(0);
        }
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : stringArray = map.keySet().toArray(new String[0])) {
            String string2 = map.get(string);
            if (string2.toLowerCase().endsWith(".dll")) {
                string2 = string2.toLowerCase();
            }
            if (!hashSet.contains(string2) && !string2.toLowerCase().contains("nssckbi")) {
                concurrentHashMap.put(string, map.get(string));
                hashSet.add(string2);
                continue;
            }
            LOGGER.warning("Se eliminara el modulo '" + string + "' porque ya existe uno con la misma biblioteca o es un modulo de certificados raiz: " + map.get(string));
        }
        return concurrentHashMap;
    }

    private static enum KnownModule {
        ATOS_CARDOS("Atos CardOS (preinstalado)", "siecap11.dll", Platform.OS.WINDOWS, false),
        FNMT_64("FNMT-RCM Modulo PKCS#11 64bits", "FNMT_P11_x64.dll", Platform.OS.WINDOWS, true),
        FNMT_32("FNMT-RCM Modulo PKCS#11 32bits", "FNMT_P11.dll", Platform.OS.WINDOWS, true);

        private String description;
        private String lib;
        private Platform.OS os;
        private boolean forcedLoad;

        private KnownModule(String string2, String string3, Platform.OS oS, boolean bl) {
            this.description = string2;
            this.lib = string3;
            this.forcedLoad = bl;
            this.os = oS;
        }

        String getDescription() {
            return this.description;
        }

        String getLib() {
            return this.lib;
        }

        boolean isForcedLoad() {
            return this.forcedLoad;
        }

        public Platform.OS getOs() {
            return this.os;
        }
    }
}

