/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.mozilla.MozillaKeyStoreUtilitiesWindows;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

final class BundledNssHelper {
    private static final int BUFFER_SIZE = 2048;
    public static final String AFIRMA_NSS_HOME = Platform.getUserHome() + File.separator + ".afirma" + File.separator + "nss" + File.separator + Platform.getJavaArch();

    BundledNssHelper() {
    }

    static String getBundledNssDirectory() throws IOException {
        File file = BundledNssHelper.getNssDirFile();
        BundledNssHelper.uncompressZip(BundledNssHelper.getNssZipResourceName(), file);
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            return MozillaKeyStoreUtilitiesWindows.getShort(file.getAbsolutePath());
        }
        String string = file.getAbsolutePath();
        Logger.getLogger("es.gob.afirma").info("Se ha encontrado un NSS incorporado en: " + string.replace(System.getProperty("user.home"), "USERHOME"));
        return string;
    }

    private static String getNssZipResourceName() {
        return "/nss/" + Platform.getOS().toString() + "/nss" + Platform.getJavaArch() + ".zip";
    }

    private static File getNssDirFile() throws IOException {
        File file = new File(AFIRMA_NSS_HOME);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("No se ha podido crear el directorio de NSS: " + AFIRMA_NSS_HOME);
        }
        if (!file.isDirectory()) {
            throw new IOException("No se ha podido crear el directorio de NSS por encontrarse un fichero con el mismo nombre: " + AFIRMA_NSS_HOME);
        }
        if (!file.canWrite() || !file.canRead()) {
            throw new IOException("No se tienen permisos sobre el directorio de NSS: " + AFIRMA_NSS_HOME);
        }
        return file;
    }

    private static void uncompressZip(String string, File file) throws IOException {
        byte[] byArray = new byte[2048];
        try (InputStream inputStream = BundledNssHelper.class.getResourceAsStream(string);
             ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                block42: {
                    if (zipEntry.isDirectory()) {
                        new File(file, zipEntry.getName()).mkdirs();
                    } else {
                        try (FileOutputStream fileOutputStream = new FileOutputStream(new File(file, zipEntry.getName()));){
                            int n;
                            while ((n = zipInputStream.read(byArray)) > 0) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                            fileOutputStream.flush();
                        }
                        catch (Exception exception) {
                            if (new File(file, zipEntry.getName()).exists()) break block42;
                            zipInputStream.closeEntry();
                            throw new IOException("No se pudo descomprimir una de las dependencias para la carga de NSS", exception);
                        }
                    }
                }
                zipInputStream.closeEntry();
            }
        }
    }
}

