/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.mozilla;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.KeyStoreUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class AOSecMod {
    private static final int FIRST_ASCII_PRINTABLE_CODE = 32;
    private static final int LAST_ASCII_PRINTABLE_CODE = 126;
    private static List<ModuleName> modules = null;

    private AOSecMod() {
    }

    private static String cleanModuleName(String string) {
        if (string == null) {
            return "";
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] >= ' ' && cArray[i] <= '~') continue;
            n = i + 1;
        }
        return string.substring(n);
    }

    private static ModuleName processNames(byte[] byArray, int n) {
        String string;
        String string2;
        int n2 = n;
        int n3 = AOSecMod.getShort(byArray, n2 + 0);
        String string3 = AOSecMod.cleanModuleName(new String(byArray, n2 + 2, n3));
        if ((AOSecMod.isWindowsLib(string2 = new String(byArray, (n2 += n3 + 2) + 2, n3 = AOSecMod.getShort(byArray, n2))) || AOSecMod.isUnixLib(string2)) && (string = KeyStoreUtilities.searchPathForFile(new String[]{string2})) != null) {
            return new ModuleName(string, string3);
        }
        throw new UnsupportedOperationException("Intento fallido: " + string2);
    }

    private static boolean isUnixLib(String string) {
        if (string == null) {
            return false;
        }
        return !Platform.OS.WINDOWS.equals((Object)Platform.getOS()) && (string.endsWith(".so") || string.contains(".so.") || string.endsWith(".dylib"));
    }

    private static boolean isWindowsLib(String string) {
        if (string == null) {
            return false;
        }
        return Platform.OS.WINDOWS.equals((Object)Platform.getOS()) && (string.endsWith(".DLL") || string.endsWith(".dll"));
    }

    static List<ModuleName> getModules(String string) throws AOException {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("El directorio del perfil de Mozilla no puede ser nulo");
        }
        String string2 = string;
        if (modules == null) {
            byte[] byArray;
            File file;
            if (!(string2 = string2.replace("\\ ", " ")).endsWith("/")) {
                string2 = string2 + "/";
            }
            if (!(file = new File(string2, "secmod.db")).exists()) {
                throw new AOException("El directorio del perfil de Mozilla proporcionado no contiene una base de datos de modulos (secmod.db)");
            }
            try {
                byArray = AOUtil.getDataFromInputStream(AOUtil.loadFile(AOUtil.createURI(file.getAbsolutePath())));
            }
            catch (Exception exception) {
                throw new AOException("Error leyendo la base de datos de modulos (secmod.db)", exception);
            }
            modules = new ArrayList<ModuleName>();
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < byArray.length; ++i) {
                try {
                    ModuleName moduleName = AOSecMod.processNames(byArray, i);
                    if (hashSet.contains(moduleName.getLib())) continue;
                    hashSet.add(moduleName.getLib());
                    modules.add(moduleName);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return modules;
    }

    private static int getShort(byte[] byArray, int n) {
        return byArray[n + 0] << 8 | byArray[n + 1];
    }

    public static final class ModuleName {
        private final String lib;
        private final String description;

        public ModuleName(String string, String string2) {
            this.lib = string;
            this.description = string2;
        }

        String getLib() {
            return this.lib;
        }

        String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.description + " (EXTERNAL, " + this.lib + ", slot 0)";
        }
    }
}

