/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters.rfc;

import es.gob.afirma.keystores.filters.CertificateFilter;
import es.gob.afirma.keystores.filters.rfc.QCStatements;
import java.io.IOException;
import java.security.cert.X509Certificate;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.x509.qualified.QCStatement;

public final class SscdFilter
extends CertificateFilter {
    private static final String QC_STATEMENTS_OID = "1.3.6.1.5.5.7.1.3";
    private static final ASN1ObjectIdentifier QC_SSCD_OID = new ASN1ObjectIdentifier("0.4.0.1862.1.4");

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        QCStatements qCStatements;
        Object object;
        Object object2;
        if (x509Certificate == null) {
            return false;
        }
        byte[] byArray = x509Certificate.getExtensionValue(QC_STATEMENTS_OID);
        if (byArray == null) {
            return false;
        }
        try {
            object2 = (DEROctetString)ASN1Primitive.fromByteArray(byArray);
            object = (ASN1Sequence)ASN1Primitive.fromByteArray(((ASN1OctetString)object2).getOctets());
            qCStatements = QCStatements.getInstance(object);
        }
        catch (IOException iOException) {
            return false;
        }
        object2 = qCStatements.getQCStatement();
        object = object2.iterator();
        while (object.hasNext()) {
            QCStatement qCStatement = (QCStatement)object.next();
            if (!QC_SSCD_OID.equals(qCStatement.getStatementId())) continue;
            return true;
        }
        return false;
    }
}

