/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters.rfc;

import es.gob.afirma.core.keystores.KeyStoreManager;
import es.gob.afirma.keystores.filters.CertificateFilter;
import es.gob.afirma.keystores.filters.rfc.SearchFilter;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public final class RFC2254CertificateFilter
extends CertificateFilter {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private final String rfc2254IssuerFilter;
    private final String rfc2254SubjectFilter;
    private final boolean recurseIssuers;

    public RFC2254CertificateFilter(String string, String string2, boolean bl) {
        if ((string == null || string.isEmpty()) && (string2 == null || string2.isEmpty())) {
            throw new IllegalArgumentException("Al menos uno de los criterios de filtrado debe no ser nulo");
        }
        this.rfc2254IssuerFilter = string2 != null && !string2.isEmpty() ? string2 : null;
        this.rfc2254SubjectFilter = string != null && !string.isEmpty() ? string : null;
        this.recurseIssuers = bl;
    }

    public RFC2254CertificateFilter(String string, String string2) {
        this(string, string2, false);
    }

    @Override
    public String[] matches(String[] stringArray, KeyStoreManager keyStoreManager) {
        if (!this.recurseIssuers) {
            return super.matches(stringArray, keyStoreManager);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (!RFC2254CertificateFilter.filterSubjectByRFC2254(this.rfc2254SubjectFilter, keyStoreManager.getCertificate(string)) || !this.matchesIssuersRecursivelly(keyStoreManager.getCertificateChain(string))) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        if (this.recurseIssuers) {
            LOGGER.warning("No se dispone de la cadena de certificacion completa, el filtro solo se aplicara al emisor inmediato");
        }
        return RFC2254CertificateFilter.filterSubjectByRFC2254(this.rfc2254SubjectFilter, x509Certificate) && RFC2254CertificateFilter.filterIssuerByRFC2254(this.rfc2254IssuerFilter, x509Certificate);
    }

    private boolean matchesIssuersRecursivelly(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray == null) {
            return false;
        }
        for (X509Certificate x509Certificate : x509CertificateArray) {
            if (!RFC2254CertificateFilter.filterSubjectByRFC2254(this.rfc2254IssuerFilter, x509Certificate)) continue;
            return true;
        }
        return false;
    }

    private static boolean filterSubjectByRFC2254(String string, X509Certificate x509Certificate) {
        if (x509Certificate == null || string == null) {
            return true;
        }
        return RFC2254CertificateFilter.filterRFC2254(string, x509Certificate.getSubjectDN().toString());
    }

    private static boolean filterIssuerByRFC2254(String string, X509Certificate x509Certificate) {
        if (x509Certificate == null || string == null) {
            return true;
        }
        return RFC2254CertificateFilter.filterRFC2254(string, x509Certificate.getIssuerDN().toString());
    }

    private static boolean filterRFC2254(String string, String string2) {
        try {
            return RFC2254CertificateFilter.filterRFC2254(string, new LdapName(string2));
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "No ha sido posible filtrar el certificado (filtro: '" + string + "', nombre: '" + string2 + "'), no se eliminara del listado: " + exception, exception);
            return true;
        }
    }

    private static boolean filterRFC2254(String string, LdapName ldapName) {
        if (string == null || ldapName == null) {
            return true;
        }
        try {
            List<Rdn> list = ldapName.getRdns();
            if (list == null || list.isEmpty()) {
                LOGGER.warning("El nombre proporcionado para filtrar no contiene atributos, no se mostrara el certificado en el listado");
                return false;
            }
            BasicAttributes basicAttributes = new BasicAttributes(true);
            for (Rdn rdn : list) {
                basicAttributes.put(rdn.getType(), rdn.getValue());
            }
            return new SearchFilter(string).check(basicAttributes);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "No ha sido posible filtrar el certificado (filtro: '" + string + "', nombre: '" + ldapName + "'), no se eliminara del listado: " + exception, exception);
            return true;
        }
    }
}

