/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters.rfc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Object;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.x509.qualified.QCStatement;

final class QCStatements
extends ASN1Object {
    private final List<QCStatement> qCStatements = new ArrayList<QCStatement>();

    private QCStatements(ASN1Sequence aSN1Sequence) {
        for (int i = 0; i < aSN1Sequence.size(); ++i) {
            this.qCStatements.add(QCStatement.getInstance(aSN1Sequence.getObjectAt(i)));
        }
    }

    static QCStatements getInstance(Object object) {
        if (object instanceof QCStatements) {
            return (QCStatements)object;
        }
        if (object instanceof ASN1Sequence) {
            return new QCStatements((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Secuencia invalida");
    }

    List<QCStatement> getQCStatement() {
        return this.qCStatements;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Iterator<QCStatement> iterator = this.qCStatements.iterator();
        while (iterator.hasNext()) {
            aSN1EncodableVector.add(iterator.next().toASN1Primitive());
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

