/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters.rfc;

import es.gob.afirma.keystores.filters.CertificateFilter;
import java.security.cert.X509Certificate;

public class KeyUsageFilter
extends CertificateFilter {
    private static final int KEYUSAGE_NBITS = 9;
    private final Boolean[] keyUsageFilter;
    public static final Boolean[] SIGN_CERT_USAGE = new Boolean[]{null, Boolean.TRUE, null, null, null, null, null, null, null};

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        boolean[] blArray;
        if (x509Certificate == null) {
            return false;
        }
        if (this.keyUsageFilter.length == 9 && (blArray = x509Certificate.getKeyUsage()) != null) {
            for (int i = 0; i < blArray.length; ++i) {
                if (this.keyUsageFilter[i] == null || this.keyUsageFilter[i] == blArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public KeyUsageFilter(Boolean[] booleanArray) {
        if (booleanArray == null) {
            throw new IllegalArgumentException("El criterio de filtrado no puede ser nulo");
        }
        this.keyUsageFilter = (Boolean[])booleanArray.clone();
    }
}

