/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.keystores.filters.CertificateFilter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;

public final class ThumbPrintCertificateFilter
extends CertificateFilter {
    private final String digestAlgorithm;
    private final String thumbprint;
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    public ThumbPrintCertificateFilter(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Se debe indicar tanto el algoritmo como la huella digital del certificado");
        }
        this.digestAlgorithm = string;
        this.thumbprint = string2.replace(" ", "");
    }

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        try {
            return this.thumbprint.equalsIgnoreCase(AOUtil.hexify(MessageDigest.getInstance(this.digestAlgorithm).digest(x509Certificate.getEncoded()), ""));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.warning("Algoritmo de huella digital no reconocido: " + noSuchAlgorithmException);
            return false;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            LOGGER.warning("No se ha podido obtener la codificacion del certificado: " + certificateEncodingException);
            return false;
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido filtrar el certificado: " + exception);
            return false;
        }
    }
}

