/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters;

import es.gob.afirma.core.keystores.KeyStoreManager;
import es.gob.afirma.keystores.filters.AuthenticationDNIeFilter;
import es.gob.afirma.keystores.filters.CertificateFilter;
import es.gob.afirma.keystores.filters.FilterUtils;
import es.gob.afirma.keystores.filters.SignatureDNIeFilter;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.logging.Logger;

public final class SSLFilter
extends CertificateFilter {
    private final String serialNumber;
    private final AuthenticationDNIeFilter authenticationDnieCertFilter;
    private final SignatureDNIeFilter signatureDnieCertFilter;

    public SSLFilter(String string) {
        this.serialNumber = SSLFilter.prepareSerialNumber(string);
        this.authenticationDnieCertFilter = new AuthenticationDNIeFilter();
        this.signatureDnieCertFilter = new SignatureDNIeFilter();
    }

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        return SSLFilter.prepareSerialNumber(SSLFilter.getCertificateSN(x509Certificate)).equalsIgnoreCase(this.serialNumber);
    }

    @Override
    public String[] matches(String[] stringArray, KeyStoreManager keyStoreManager) {
        X509Certificate[] x509CertificateArray = new X509Certificate[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            x509CertificateArray[i] = keyStoreManager.getCertificate(stringArray[i]);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            X509Certificate x509Certificate = keyStoreManager.getCertificate(stringArray[i]);
            try {
                if (!this.matches(x509Certificate)) continue;
                if (this.isAuthenticationDnieCert(x509Certificate)) {
                    String string = this.getAssociatedCertAlias(keyStoreManager, x509Certificate, stringArray, i);
                    if (string == null) continue;
                    arrayList.add(string);
                    continue;
                }
                arrayList.add(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").warning("Error en la verificacion del certificado '" + x509Certificate.getSerialNumber() + "': " + exception);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private boolean isAuthenticationDnieCert(X509Certificate x509Certificate) {
        return this.authenticationDnieCertFilter.matches(x509Certificate);
    }

    private boolean isSignatureDnieCert(X509Certificate x509Certificate) {
        return this.signatureDnieCertFilter.matches(x509Certificate);
    }

    private String getAssociatedCertAlias(KeyStoreManager keyStoreManager, X509Certificate x509Certificate, String[] stringArray, int n) {
        for (int i = 0; i < stringArray.length; ++i) {
            X509Certificate x509Certificate2;
            if (n == i || !this.isSignatureDnieCert(x509Certificate2 = keyStoreManager.getCertificate(stringArray[i])) || FilterUtils.getSubjectSN(x509Certificate2) == null || !FilterUtils.getSubjectSN(x509Certificate2).equalsIgnoreCase(FilterUtils.getSubjectSN(x509Certificate)) || !SSLFilter.getExpiredDate(x509Certificate2).equals(SSLFilter.getExpiredDate(x509Certificate))) continue;
            return stringArray[i];
        }
        return null;
    }

    private static String getExpiredDate(X509Certificate x509Certificate) {
        return new SimpleDateFormat("yyyy-MM-dd").format(x509Certificate.getNotAfter());
    }

    private static String getCertificateSN(X509Certificate x509Certificate) {
        return FilterUtils.bigIntegerToHex(x509Certificate.getSerialNumber());
    }

    private static String prepareSerialNumber(String string) {
        int n;
        String string2 = string.trim().replace(" ", "").replace("#", "");
        for (n = 0; n < string2.length() && string2.charAt(n) == '0'; ++n) {
        }
        return string2.substring(n);
    }
}

