/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters;

import es.gob.afirma.core.keystores.KeyStoreManager;
import es.gob.afirma.keystores.filters.AuthenticationDNIeFilter;
import es.gob.afirma.keystores.filters.CertificateFilter;
import es.gob.afirma.keystores.filters.FilterUtils;
import es.gob.afirma.keystores.filters.KeyUsagesPattern;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Logger;

public final class QualifiedCertificatesFilter
extends CertificateFilter {
    private final String serialNumber;

    public QualifiedCertificatesFilter(String string) {
        this.serialNumber = QualifiedCertificatesFilter.prepareSerialNumber(string);
    }

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        return QualifiedCertificatesFilter.prepareSerialNumber(QualifiedCertificatesFilter.getCertificateSN(x509Certificate)).equalsIgnoreCase(this.serialNumber);
    }

    @Override
    public String[] matches(String[] stringArray, KeyStoreManager keyStoreManager) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            X509Certificate x509Certificate = keyStoreManager.getCertificate(string);
            if (x509Certificate == null) {
                Logger.getLogger("es.gob.afirma").warning("No se pudo recuperar el certificado: " + string);
                continue;
            }
            try {
                if (!this.matches(x509Certificate)) continue;
                if (QualifiedCertificatesFilter.isSignatureCert(x509Certificate)) {
                    arrayList.add(string);
                    continue;
                }
                String string2 = QualifiedCertificatesFilter.searchQualifiedSignatureCertificate(x509Certificate, keyStoreManager, stringArray);
                if (string2 == null) {
                    if (new AuthenticationDNIeFilter().matches(x509Certificate)) continue;
                    arrayList.add(string);
                    continue;
                }
                arrayList.add(string2);
            }
            catch (Exception exception) {
                Logger.getLogger("es.gob.afirma").warning("Error en la verificacion del certificado '" + x509Certificate.getSerialNumber() + "': " + exception);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String searchQualifiedSignatureCertificate(X509Certificate x509Certificate, KeyStoreManager keyStoreManager, String[] stringArray) {
        for (String string : stringArray) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            X509Certificate x509Certificate2 = keyStoreManager.getCertificate(string);
            if (x509Certificate.getSerialNumber().equals(x509Certificate2.getSerialNumber())) continue;
            boolean bl4 = x509Certificate.getIssuerDN() == null ? x509Certificate2.getIssuerDN() == null : (bl3 = x509Certificate.getIssuerDN().equals(x509Certificate2.getIssuerDN()));
            boolean bl5 = FilterUtils.getSubjectSN(x509Certificate) == null ? FilterUtils.getSubjectSN(x509Certificate2) == null : (bl2 = FilterUtils.getSubjectSN(x509Certificate).equals(FilterUtils.getSubjectSN(x509Certificate2)));
            boolean bl6 = QualifiedCertificatesFilter.getExpiredDate(x509Certificate) == null ? QualifiedCertificatesFilter.getExpiredDate(x509Certificate2) == null : (bl = QualifiedCertificatesFilter.getExpiredDate(x509Certificate).equals(QualifiedCertificatesFilter.getExpiredDate(x509Certificate2)));
            if (!QualifiedCertificatesFilter.isSignatureCert(x509Certificate2) || !bl3 || !bl2 || !bl) continue;
            Logger.getLogger("es.gob.afirma").info("Se selecciona un certificado pareja de firma del certificado del numero de serie indicado");
            return string;
        }
        return null;
    }

    private static boolean isSignatureCert(X509Certificate x509Certificate) {
        if (x509Certificate.getKeyUsage() == null) {
            return false;
        }
        KeyUsagesPattern keyUsagesPattern = new KeyUsagesPattern(x509Certificate.getIssuerDN());
        return QualifiedCertificatesFilter.checkKeyUsages(x509Certificate.getKeyUsage(), keyUsagesPattern.getSignaturePattern());
    }

    private static boolean checkKeyUsages(boolean[] blArray, Boolean[] booleanArray) {
        for (int i = 0; i < booleanArray.length; ++i) {
            if (booleanArray[i] == null || booleanArray[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    private static String getExpiredDate(X509Certificate x509Certificate) {
        return new SimpleDateFormat("yyyy-MM-dd", Locale.US).format(x509Certificate.getNotAfter());
    }

    private static String getCertificateSN(X509Certificate x509Certificate) {
        return x509Certificate.getSerialNumber() == null ? null : FilterUtils.bigIntegerToHex(x509Certificate.getSerialNumber());
    }

    private static String prepareSerialNumber(String string) {
        int n;
        String string2 = string.trim().replace(" ", "").replace("#", "");
        for (n = 0; n < string2.length() && string2.charAt(n) == '0'; ++n) {
        }
        return string2.substring(n);
    }
}

