/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters;

import es.gob.afirma.core.keystores.KeyStoreManager;
import es.gob.afirma.keystores.filters.CertificateFilter;
import es.gob.afirma.keystores.filters.PolicyIdFilter;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class PseudonymFilter
extends CertificateFilter {
    private static final String PSEUDONYM_POLICY_OID = "2.16.724.1.2.1.102.41";
    private static final CertificateFilter PSEUDONYM_POLICY_FILTER = new PolicyIdFilter(Collections.singletonList("2.16.724.1.2.1.102.41"));

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        return PSEUDONYM_POLICY_FILTER.matches(x509Certificate);
    }

    @Override
    public String[] matches(String[] stringArray, KeyStoreManager keyStoreManager) {
        Object object;
        ConcurrentHashMap<String, X509Certificate> concurrentHashMap = new ConcurrentHashMap<String, X509Certificate>(stringArray.length);
        ConcurrentHashMap<String, X509Certificate> concurrentHashMap2 = new ConcurrentHashMap<String, X509Certificate>();
        for (String object2 : stringArray) {
            object = keyStoreManager.getCertificate(object2);
            if (this.matches((X509Certificate)object)) {
                concurrentHashMap2.put(object2, (X509Certificate)object);
                continue;
            }
            concurrentHashMap.put(object2, (X509Certificate)object);
        }
        if (concurrentHashMap2.isEmpty()) {
            return stringArray;
        }
        Set set = concurrentHashMap2.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            X509Certificate x509Certificate = (X509Certificate)concurrentHashMap2.get(string);
            object = concurrentHashMap.keySet();
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                X509Certificate x509Certificate2 = (X509Certificate)concurrentHashMap.get(string2);
                if (!PseudonymFilter.isPseudonymFor(x509Certificate, x509Certificate2)) continue;
                concurrentHashMap.remove(string2);
            }
        }
        concurrentHashMap2.putAll(concurrentHashMap);
        return concurrentHashMap2.keySet().toArray(new String[0]);
    }

    private static boolean isPseudonymFor(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        if (x509Certificate == null || x509Certificate2 == null) {
            return false;
        }
        return x509Certificate.getIssuerX500Principal().equals(x509Certificate2.getIssuerX500Principal()) && PseudonymFilter.compareArrays(x509Certificate.getKeyUsage(), x509Certificate2.getKeyUsage());
    }

    private static boolean compareArrays(boolean[] blArray, boolean[] blArray2) {
        if (blArray != null && blArray2 != null) {
            if (blArray.length != blArray2.length) {
                return false;
            }
            for (int i = 0; i < blArray2.length; ++i) {
                if (blArray2[i] == blArray[i]) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

