/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters;

import es.gob.afirma.keystores.filters.CertificateFilter;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.x509.CertificatePolicies;
import org.spongycastle.asn1.x509.PolicyInformation;

public final class PolicyIdFilter
extends CertificateFilter {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    public static final String OID_SEPARATOR = ";";
    final List<String> allowedOids;

    public PolicyIdFilter(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("La lista de OID permitidos no puede ser nula ni vacia");
        }
        this.allowedOids = Arrays.asList(string.split(OID_SEPARATOR));
    }

    public PolicyIdFilter(List<String> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("La lista de OID permitidos no puede ser nula ni vacia");
        }
        this.allowedOids = list;
    }

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            LOGGER.warning("El certificado proporcionado es nulo, se considera que no cumple el filtro");
            return false;
        }
        List<String> list = PolicyIdFilter.getCertificatePolicyIds(x509Certificate);
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (String string : list) {
            if (this.allowedOids.contains(string)) continue;
            return false;
        }
        return true;
    }

    private static List<String> getCertificatePolicyIds(X509Certificate x509Certificate) {
        byte[] byArray = x509Certificate.getExtensionValue("2.5.29.32");
        if (byArray == null || byArray.length < 1) {
            return new ArrayList<String>(0);
        }
        CertificatePolicies certificatePolicies = CertificatePolicies.getInstance(ASN1Sequence.getInstance(ASN1OctetString.getInstance(byArray).getOctets()));
        PolicyInformation[] policyInformationArray = certificatePolicies.getPolicyInformation();
        ArrayList<String> arrayList = new ArrayList<String>(policyInformationArray.length);
        for (PolicyInformation policyInformation : policyInformationArray) {
            arrayList.add(policyInformation.getPolicyIdentifier().toString());
        }
        return arrayList;
    }
}

