/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters;

import es.gob.afirma.core.misc.AOUtil;
import java.math.BigInteger;
import java.security.cert.X509Certificate;

final class FilterUtils {
    private static final String[] SUBJECT_SN_RDN = new String[]{"serialnumber", "2.5.4.5"};

    private FilterUtils() {
    }

    static String getSubjectSN(X509Certificate x509Certificate) {
        String string = x509Certificate.getSubjectX500Principal().getName();
        for (String string2 : SUBJECT_SN_RDN) {
            String string3 = AOUtil.getRDNvalueFromLdapName(string2, string);
            if (string3 == null) continue;
            return string3.replace("#", "");
        }
        return null;
    }

    static String bigIntegerToHex(BigInteger bigInteger) {
        return AOUtil.hexify(bigInteger.toByteArray(), "");
    }
}

