/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters;

import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.keystores.filters.CertificateFilter;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;

public final class EncodedCertificateFilter
extends CertificateFilter {
    private final String certEncoded;

    public EncodedCertificateFilter(String string) {
        if (string == null) {
            throw new NullPointerException("No se ha indicado el certificado que se desea obtener");
        }
        this.certEncoded = string;
    }

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        try {
            return this.certEncoded.equals(Base64.encode(x509Certificate.getEncoded()));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            Logger.getLogger("es.gob.afirma").warning("No se ha podido codificar el certificado en base 64. Se ignorara: " + certificateEncodingException);
            return false;
        }
    }
}

