/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores.filters;

import es.gob.afirma.keystores.filters.AuthCertificateFilter;
import es.gob.afirma.keystores.filters.CertificateFilter;
import es.gob.afirma.keystores.filters.EncodedCertificateFilter;
import es.gob.afirma.keystores.filters.ExpiredCertificateFilter;
import es.gob.afirma.keystores.filters.MultipleCertificateFilter;
import es.gob.afirma.keystores.filters.PolicyIdFilter;
import es.gob.afirma.keystores.filters.PseudonymFilter;
import es.gob.afirma.keystores.filters.QualifiedCertificatesFilter;
import es.gob.afirma.keystores.filters.SSLFilter;
import es.gob.afirma.keystores.filters.SignatureDNIeFilter;
import es.gob.afirma.keystores.filters.SigningCertificateFilter;
import es.gob.afirma.keystores.filters.TextContainedCertificateFilter;
import es.gob.afirma.keystores.filters.ThumbPrintCertificateFilter;
import es.gob.afirma.keystores.filters.rfc.KeyUsageFilter;
import es.gob.afirma.keystores.filters.rfc.RFC2254CertificateFilter;
import es.gob.afirma.keystores.filters.rfc.SscdFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public final class CertFilterManager {
    private static final String HEADLESS_PREFIX_KEY = "headless";
    private static final String FILTER_PREFIX_KEY = "filter";
    private static final String FILTERS_PREFIX_KEY = "filters";
    private static final String FILTERS_ENUM_SEPARATOR = ".";
    private static final String FILTERS_SEPARATOR = ";";
    private static final String FILTER_TYPE_DISABLE_EXTERNAL_STORES = "disableopeningexternalstores";
    private static final String FILTER_TYPE_DNIE = "dnie:";
    private static final String FILTER_TYPE_SSL = "ssl:";
    private static final String FILTER_TYPE_QUALIFIED = "qualified:";
    private static final String FILTER_TYPE_SIGNING_CERTIFICATE = "signingcert:";
    private static final String FILTER_TYPE_AUTHENTICATION_CERTIFICATE = "authcert:";
    private static final String FILTER_TYPE_NON_EXPIRED = "nonexpired:";
    private static final String FILTER_TYPE_SSCD = "sscd:";
    private static final String FILTER_TYPE_SUBJECT_RFC2254 = "subject.rfc2254:";
    private static final String FILTER_TYPE_SUBJECT_CONTAINS = "subject.contains:";
    private static final String FILTER_TYPE_ISSUER_RFC2254 = "issuer.rfc2254:";
    private static final String FILTER_TYPE_ISSUER_RFC2254_RECURSE = "issuer.rfc2254.recurse:";
    private static final String FILTER_TYPE_ISSUER_CONTAINS = "issuer.contains:";
    private static final String FILTER_TYPE_THUMBPRINT = "thumbprint:";
    private static final String FILTER_TYPE_POLICY_ID = "policyid:";
    private static final String FILTER_TYPE_PSEUDONYM = "pseudonym:";
    private static final String FILTER_TYPE_ENCODED_CERT = "encodedcert:";
    private static final String FILTER_PREFIX_KEYUSAGE = "keyusage.";
    private static final String FILTER_TYPE_KEYUSAGE_DIGITAL_SIGNATURE = "keyusage.digitalsignature:";
    private static final String FILTER_TYPE_KEYUSAGE_NON_REPUDIATION = "keyusage.nonrepudiation:";
    private static final String FILTER_TYPE_KEYUSAGE_KEY_ENCIPHERMENT = "keyusage.keyencipherment:";
    private static final String FILTER_TYPE_KEYUSAGE_DATA_ENCIPHERMENT = "keyusage.dataencipherment:";
    private static final String FILTER_TYPE_KEYUSAGE_KEY_AGREEMENT = "keyusage.keyagreement:";
    private static final String FILTER_TYPE_KEYUSAGE_KEY_CERT_SIGN = "keyusage.keycertsign:";
    private static final String FILTER_TYPE_KEYUSAGE_CRL_SIGN = "keyusage.crlsign:";
    private static final String FILTER_TYPE_KEYUSAGE_ENCIPHER_ONLY = "keyusage.encipheronly:";
    private static final String FILTER_TYPE_KEYUSAGE_DECIPHER_ONLY = "keyusage.decipheronly:";
    private static final String[] PATTERN_KEYUSAGES_FILTER = new String[]{"keyusage.digitalsignature:", "keyusage.nonrepudiation:", "keyusage.keyencipherment:", "keyusage.dataencipherment:", "keyusage.keyagreement:", "keyusage.keycertsign:", "keyusage.crlsign:", "keyusage.encipheronly:", "keyusage.decipheronly:"};
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private boolean mandatoryCertificate = false;
    private final List<CertificateFilter> filters = new ArrayList<CertificateFilter>();
    private boolean allowExternalStores = true;

    public CertFilterManager(Properties properties) {
        this.mandatoryCertificate = Boolean.parseBoolean(properties.getProperty(HEADLESS_PREFIX_KEY));
        List<String> list = CertFilterManager.getFilterValues(properties);
        if (list.isEmpty()) {
            return;
        }
        for (String string : list) {
            this.filters.add(this.parseFilter(string));
        }
    }

    public boolean isExternalStoresOpeningAllowed() {
        return this.allowExternalStores;
    }

    private static List<String> getFilterValues(Properties properties) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (properties.containsKey(FILTER_PREFIX_KEY)) {
            arrayList.add(properties.getProperty(FILTER_PREFIX_KEY));
        } else if (properties.containsKey(FILTERS_PREFIX_KEY)) {
            arrayList.add(properties.getProperty(FILTERS_PREFIX_KEY));
        } else if (properties.containsKey("filters.1")) {
            int n = 1;
            while (properties.containsKey("filters." + n)) {
                arrayList.add(properties.getProperty("filters." + n));
                ++n;
            }
        }
        return arrayList;
    }

    private CertificateFilter parseFilter(String string) {
        ArrayList<CertificateFilter> arrayList = new ArrayList<CertificateFilter>();
        Object[] objectArray = string.split(FILTERS_SEPARATOR);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            Object object2 = objectArray[i];
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_DNIE)) {
                arrayList.add(new SignatureDNIeFilter());
                continue;
            }
            if (((String)object2).toLowerCase().equals(FILTER_TYPE_DISABLE_EXTERNAL_STORES)) {
                this.allowExternalStores = false;
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_SSL)) {
                arrayList.add(new SSLFilter(((String)object2).substring(FILTER_TYPE_SSL.length())));
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_QUALIFIED)) {
                arrayList.add(new QualifiedCertificatesFilter(((String)object2).substring(FILTER_TYPE_QUALIFIED.length())));
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_SIGNING_CERTIFICATE)) {
                arrayList.add(new SigningCertificateFilter());
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_AUTHENTICATION_CERTIFICATE)) {
                arrayList.add(new AuthCertificateFilter());
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_PREFIX_KEYUSAGE)) {
                object = CertFilterManager.generateKeyUsageFiltersPattern((String[])objectArray, i);
                arrayList.add(new KeyUsageFilter((Boolean[])object));
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_NON_EXPIRED)) {
                arrayList.add(new ExpiredCertificateFilter());
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_SSCD)) {
                arrayList.add(new SscdFilter());
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_SUBJECT_RFC2254)) {
                arrayList.add(new RFC2254CertificateFilter(((String)object2).substring(FILTER_TYPE_SUBJECT_RFC2254.length()), null));
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_SUBJECT_CONTAINS)) {
                arrayList.add(new TextContainedCertificateFilter(new String[]{((String)object2).substring(FILTER_TYPE_SUBJECT_CONTAINS.length())}, null));
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_ISSUER_RFC2254)) {
                arrayList.add(new RFC2254CertificateFilter(null, ((String)object2).substring(FILTER_TYPE_ISSUER_RFC2254.length())));
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_ISSUER_RFC2254_RECURSE)) {
                arrayList.add(new RFC2254CertificateFilter(null, ((String)object2).substring(FILTER_TYPE_ISSUER_RFC2254_RECURSE.length()), true));
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_ISSUER_CONTAINS)) {
                arrayList.add(new TextContainedCertificateFilter(null, new String[]{((String)object2).substring(FILTER_TYPE_ISSUER_CONTAINS.length())}));
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_THUMBPRINT)) {
                object = ((String)object2).substring(FILTER_TYPE_THUMBPRINT.length()).split(":");
                if (((Object[])object).length != 2) continue;
                arrayList.add(new ThumbPrintCertificateFilter((String)object[0], (String)(((Object)object).length > 1 ? object[1] : null)));
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_POLICY_ID)) {
                object = ((String)object2).substring(FILTER_TYPE_POLICY_ID.length());
                if (object == null || ((String)object).isEmpty()) continue;
                arrayList.add(new PolicyIdFilter(Arrays.asList(((String)object).split(","))));
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_PSEUDONYM)) {
                arrayList.add(new PseudonymFilter());
                continue;
            }
            if (((String)object2).toLowerCase().startsWith(FILTER_TYPE_ENCODED_CERT)) {
                arrayList.add(new EncodedCertificateFilter(((String)object2).substring(FILTER_TYPE_ENCODED_CERT.length())));
                continue;
            }
            LOGGER.warning("Se omitira el filtro '" + (String)object2 + "' por no estar reconocido");
        }
        return arrayList.size() == 1 ? (CertificateFilter)arrayList.get(0) : new MultipleCertificateFilter(arrayList.toArray(new CertificateFilter[arrayList.size()]));
    }

    private static Boolean[] generateKeyUsageFiltersPattern(String[] stringArray, int n) {
        int n2 = n;
        String string = stringArray[n];
        Boolean[] booleanArray = new Boolean[PATTERN_KEYUSAGES_FILTER.length];
        do {
            CertFilterManager.processKeyUsageFilterDeclaration(string, booleanArray);
        } while (stringArray.length > n2 + 1 && stringArray[n2 + 1].startsWith(FILTER_PREFIX_KEYUSAGE) && (string = stringArray[++n2]).toLowerCase().startsWith(FILTER_PREFIX_KEYUSAGE));
        return booleanArray;
    }

    private static void processKeyUsageFilterDeclaration(String string, Boolean[] booleanArray) {
        int n = -1;
        for (int i = 0; n < 0 && i < PATTERN_KEYUSAGES_FILTER.length; ++i) {
            if (!string.toLowerCase().startsWith(PATTERN_KEYUSAGES_FILTER[i])) continue;
            n = i;
        }
        if (n >= 0) {
            String string2 = string.substring(string.indexOf(58) + 1);
            booleanArray[n] = string2.equalsIgnoreCase("null") ? null : Boolean.valueOf(string2);
        }
    }

    public List<CertificateFilter> getFilters() {
        return this.filters != null ? new ArrayList<CertificateFilter>(this.filters) : null;
    }

    public boolean isMandatoryCertificate() {
        return this.mandatoryCertificate;
    }
}

