/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.AggregatedKeyStoreManager;
import es.gob.afirma.keystores.KeyStoreMessages;
import es.gob.afirma.keystores.KeyStoreUtilities;
import es.gob.afirma.keystores.callbacks.UIPasswordCallback;
import java.io.IOException;
import java.io.InputStream;
import javax.security.auth.callback.PasswordCallback;

public class SmartCardUnifiedKeyStoreManager
extends AggregatedKeyStoreManager {
    private PasswordCallback passwordCallback = null;
    private Object[] configParams = null;
    private boolean preferredKsAdded = false;
    private boolean initialized = false;

    public SmartCardUnifiedKeyStoreManager() {
        this.setKeyStoreType(AOKeyStore.KNOWN_SMARTCARDS);
    }

    @Override
    public final void init(AOKeyStore aOKeyStore, InputStream inputStream, PasswordCallback passwordCallback, Object[] objectArray, boolean bl) {
        this.passwordCallback = passwordCallback;
        this.configParams = objectArray;
        Object object = objectArray != null && objectArray.length > 0 ? objectArray[0] : null;
        boolean bl2 = false;
        this.removeAll();
        if (bl || !this.initialized) {
            try {
                this.preferredKsAdded = KeyStoreUtilities.addPreferredKeyStoreManagers(this, object);
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                LOGGER.info("Se cancelo el uso del driver Java: " + aOCancelledOperationException);
                this.preferredKsAdded = false;
                bl2 = true;
            }
        }
        if (!this.preferredKsAdded) {
            boolean bl3 = false;
            for (KnownSmartCardsPkcs11 knownSmartCardsPkcs11 : KnownSmartCardsPkcs11.values()) {
                LOGGER.warning("Intentamos cargar: " + knownSmartCardsPkcs11.getDescription());
                if (bl2 && knownSmartCardsPkcs11.isPreferred()) continue;
                for (String string : knownSmartCardsPkcs11.getPkcs11Names()) {
                    AOKeyStoreManager aOKeyStoreManager;
                    LOGGER.warning("Probamos con la biblioteca: " + string);
                    try {
                        aOKeyStoreManager = SmartCardUnifiedKeyStoreManager.initPkcs11(knownSmartCardsPkcs11.getDescription(), object, bl, string);
                    }
                    catch (AOCancelledOperationException aOCancelledOperationException) {
                        LOGGER.warning("Se cancelo el acceso al almacen externo  '" + knownSmartCardsPkcs11.getDescription() + "', se continuara con el siguiente: " + aOCancelledOperationException);
                        continue;
                    }
                    catch (Exception exception) {
                        LOGGER.warning("Fallo el acceso al almacen externo  '" + knownSmartCardsPkcs11.getDescription() + "', se reintentara: " + exception);
                        if (!Platform.OS.LINUX.equals((Object)Platform.getOS())) continue;
                        try {
                            aOKeyStoreManager = SmartCardUnifiedKeyStoreManager.initPkcs11(knownSmartCardsPkcs11.getDescription(), object, bl, string);
                        }
                        catch (AOCancelledOperationException aOCancelledOperationException) {
                            LOGGER.warning("Se cancelo el acceso al almacen externo  '" + knownSmartCardsPkcs11.getDescription() + "', se continuara con el siguiente: " + aOCancelledOperationException);
                        }
                        catch (Exception exception2) {
                            LOGGER.warning("Fallo el acceso al almacen externo  '" + knownSmartCardsPkcs11.getDescription() + "', se continuara con el siguiente: " + exception2);
                        }
                        continue;
                    }
                    bl3 = true;
                    this.addKeyStoreManager(aOKeyStoreManager);
                    LOGGER.info("El almacen externo '" + knownSmartCardsPkcs11.getDescription() + "' ha podido inicializarse, se anadiran sus entradas");
                    break;
                }
                if (bl3) break;
            }
        }
        this.initialized = true;
    }

    private static AOKeyStoreManager initPkcs11(String string, Object object, boolean bl, String string2) throws AOKeyStoreManagerException, IOException {
        AOKeyStoreManager aOKeyStoreManager = new AOKeyStoreManager();
        aOKeyStoreManager.init(AOKeyStore.PKCS11, null, new UIPasswordCallback(KeyStoreMessages.getString("SmartCardUnifiedKeyStoreManager.0", string.toString()), object), new String[]{string2, string.toString()}, bl);
        return aOKeyStoreManager;
    }

    @Override
    public void refresh() throws IOException {
        this.init(AOKeyStore.KNOWN_SMARTCARDS, null, this.passwordCallback, this.configParams, true);
    }

    private static enum KnownSmartCardsPkcs11 {
        CERES("FNMT-CERES", new String[]{"%SYSTEMROOT%/System32/FNMT_P11_x64.dll", "%SYSTEMROOT%/System32/FNMT_P11.dll", "%SYSTEMROOT%/SysWOW64/FNMT_P11.dll"}, true),
        CARDOS("CardOS", new String[]{"%SYSTEMROOT%/SysWOW64/siecap11.dll", "%SYSTEMROOT%/System32/siecap11.dll"}, false),
        TUI("TUI", new String[]{"%PROGRAMFILES%/umu/Third-Party/Gemalto/Classic Client/BIN/gclib.dll", "%PROGRAMFILES(x86)%/umu/Third-Party/Gemalto/Classic Client/BIN/gclib.dll", "%PROGRAMFILES%/umu/UMU-Crypto/lib/libumupkcs11.dll", "%PROGRAMFILES(x86)%/umu/UMU-Crypto/lib/libumupkcs11.dll", "%PROGRAMFILES%/Gemalto/IDGo 800 PKCS#11/IDPrimePKCS1164.dll", "%PROGRAMFILES%/Gemalto/IDGo 800 PKCS#11/IDPrimePKCS11.dll", "%PROGRAMFILES(x86)%/Gemalto/IDGo 800 PKCS#11/IDPrimePKCS1164.dll", "%PROGRAMFILES(x86)%/Gemalto/IDGo 800 PKCS#11/IDPrimePKCS11.dll"}, false),
        SAFESIGN("SafeSign", new String[]{"%SYSTEMROOT%/SysWOW64/aetpkss1.dll", "%SYSTEMROOT%/System32/aetpkss1.dll"}, false);

        private static final String[] ENV_PROPERTIES;
        private String description;
        private String[] pkcs11Names;
        private boolean preferredKs;

        private KnownSmartCardsPkcs11(String string2, String[] stringArray, boolean bl) {
            this.description = string2;
            this.pkcs11Names = stringArray;
            this.preferredKs = bl;
        }

        public String getDescription() {
            return this.description;
        }

        public String[] getPkcs11Names() {
            String[] stringArray = new String[this.pkcs11Names.length];
            for (int i = 0; i < this.pkcs11Names.length; ++i) {
                stringArray[i] = KnownSmartCardsPkcs11.replaceEnvProperties(this.pkcs11Names[i]);
            }
            return stringArray;
        }

        private static String replaceEnvProperties(String string) {
            String string2 = string;
            for (String string3 : ENV_PROPERTIES) {
                if (!string2.contains(string3)) continue;
                string2 = string2.replace(string3, System.getenv(string3.substring(1, string3.length() - 1)));
            }
            return string2;
        }

        public boolean isPreferred() {
            return this.preferredKs;
        }

        static {
            ENV_PROPERTIES = new String[]{"%PROGRAMFILES%", "%PROGRAMFILES(x86)%", "%SYSTEMROOT%"};
        }
    }
}

