/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.keystores.KeyStoreManager;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerFactory;
import es.gob.afirma.keystores.AOKeystoreAlternativeException;
import es.gob.afirma.keystores.AggregatedKeyStoreManager;
import es.gob.afirma.keystores.KeyStoreMessages;
import es.gob.afirma.keystores.filters.CertificateFilter;
import es.gob.jmulticard.CancelledOperationException;
import es.gob.jmulticard.card.AuthenticationModeLockedException;
import es.gob.jmulticard.jse.provider.BadPasswordProviderException;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.swing.JOptionPane;

public final class KeyStoreUtilities {
    public static final String DISABLE_DNIE_NATIVE_DRIVER_ENV = "AFIRMA_NSS_DISABLE_DNIE_NATIVE_DRIVER";
    public static final String DISABLE_DNIE_NATIVE_DRIVER = "es.gob.afirma.keystores.mozilla.disableDnieNativeDriver";
    public static final String DISABLE_CERES_NATIVE_DRIVER_ENV = "AFIRMA_NSS_DISABLE_CERES_NATIVE_DRIVER";
    public static final String DISABLE_CERES_NATIVE_DRIVER = "es.gob.afirma.keystores.mozilla.disableCeresNativeDriver";
    public static final String ENABLE_GYDSC_NATIVE_DRIVER_ENV = "AFIRMA_NSS_ENABLE_GYDSC_NATIVE_DRIVER";
    public static final String ENABLE_GYDSC_NATIVE_DRIVER = "es.gob.afirma.keystores.mozilla.enableGYDSCNativeDriver";
    static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String[] FNMT_PKCS11_LIBS_WITHOUT_SHA1 = new String[]{"DNIe_P11_priv.dll", "DNIe_P11_pub.dll", "FNMT_P11.dll", "FNMT_P11_x64.dll", "UsrPkcs11.dll", "UsrPubPkcs11.dll", "TIF_P11.dll"};
    private static final String PIN_ERROR_LOCKED = "CKR_PIN_LOCKED";
    private static final String PIN_ERROR_WRONG_LENGTH = "CKR_PIN_LEN_RANGE";
    private static final String PIN_ERROR_INCORRECT = "CKR_PIN_INCORRECT";
    private static final int ALIAS_MAX_LENGTH = 120;

    private KeyStoreUtilities() {
    }

    static String createPKCS11ConfigFile(String string, String string2, Integer n) {
        StringBuilder stringBuilder = new StringBuilder("library=");
        stringBuilder.append(KeyStoreUtilities.getLibraryPath(string));
        stringBuilder.append("\r\n").append("name=").append(string2 != null ? string2 : "AFIRMA-PKCS11").append("\r\nshowInfo=true\r\n");
        if (n != null) {
            stringBuilder.append("slot=").append(n).append("\r\n");
        }
        for (String string3 : FNMT_PKCS11_LIBS_WITHOUT_SHA1) {
            if (!string3.equalsIgnoreCase(new File(string).getName())) continue;
            stringBuilder.append("disabledMechanisms={ CKM_SHA1_RSA_PKCS }\r\n");
            break;
        }
        LOGGER.info("Creada configuracion PKCS#11:\r\n" + stringBuilder.toString());
        return stringBuilder.toString();
    }

    private static String getLibraryPath(String string) {
        String string2;
        File file = new File(string);
        if (!file.isFile() && !file.isAbsolute()) {
            boolean bl = false;
            String[] stringArray = System.getProperty("java.library.path").split(File.pathSeparator);
            for (int i = 0; i < stringArray.length && !bl; ++i) {
                File file2 = new File(stringArray[i], string);
                if (!file2.isFile()) continue;
                file = file2;
                bl = true;
            }
        }
        if ((string2 = file.getAbsolutePath()).contains(")") || string2.contains("(")) {
            string2 = KeyStoreUtilities.getShort(string2);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, String> getAliasesByFriendlyName(String[] stringArray, KeyStoreManager keyStoreManager, boolean bl, boolean bl2, List<? extends CertificateFilter> list) {
        String[] stringArray2 = (String[])stringArray.clone();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(stringArray2.length);
        for (String string : stringArray2) {
            hashtable.put(string, string);
        }
        if (keyStoreManager != null) {
            void var11_26;
            void var11_23;
            Object object = hashtable.keySet().toArray(new String[hashtable.size()]);
            int n = ((String[])object).length;
            boolean bl3 = false;
            while (var11_23 < n) {
                block26: {
                    String string = object[var11_23];
                    X509Certificate x509Certificate = null;
                    try {
                        x509Certificate = keyStoreManager.getCertificate(string);
                    }
                    catch (AOCancelledOperationException aOCancelledOperationException) {
                        throw aOCancelledOperationException;
                    }
                    catch (RuntimeException runtimeException) {
                        if (runtimeException instanceof CancelledOperationException || runtimeException instanceof AuthenticationModeLockedException || runtimeException instanceof BadPasswordProviderException) {
                            throw runtimeException;
                        }
                        LOGGER.warning("No se ha inicializado el KeyStore indicado: " + runtimeException);
                        break block26;
                    }
                    if (x509Certificate == null) {
                        LOGGER.warning("El KeyStore no permite extraer el certificado publico para el siguiente alias: " + string);
                    } else {
                        if (!bl2) {
                            try {
                                x509Certificate.checkValidity();
                            }
                            catch (Exception exception) {
                                LOGGER.info("Se ocultara el certificado '" + string + "' por no ser valido: " + exception);
                                hashtable.remove(string);
                                break block26;
                            }
                        }
                        if (bl) {
                            try {
                                if (!keyStoreManager.isKeyEntry(string)) {
                                    hashtable.remove(string);
                                    LOGGER.info("Se ha ocultado un certificado (emitido por '" + AOUtil.getCN(x509Certificate.getIssuerX500Principal().toString()) + "') por no soportar operaciones de clave privada");
                                }
                            }
                            catch (Exception exception) {
                                hashtable.remove(string);
                                LOGGER.info("Se ha ocultado un certificado (emitido por '" + AOUtil.getCN(x509Certificate.getIssuerX500Principal().toString()) + "') por no poderse comprobar su clave privada: " + exception);
                            }
                        }
                    }
                }
                ++var11_23;
            }
            if (list != null && list.size() > 0) {
                object = new Hashtable();
                for (CertificateFilter certificateFilter : list) {
                    for (String string : certificateFilter.matches(hashtable.keySet().toArray(new String[hashtable.size()]), keyStoreManager)) {
                        object.put(string, hashtable.get(string));
                    }
                }
                hashtable.clear();
                hashtable.putAll((Map<String, String>)object);
            }
            object = hashtable.keySet().toArray(new String[0]);
            int n2 = ((String[])object).length;
            boolean bl4 = false;
            while (var11_26 < n2) {
                String string = object[var11_26];
                String string2 = AOUtil.getCN(keyStoreManager.getCertificate(string));
                if (string2 != null) {
                    hashtable.put(string, string2);
                } else {
                    hashtable.put(string, string.trim());
                }
                ++var11_26;
            }
        } else {
            for (String string : hashtable.keySet().toArray(new String[hashtable.size()])) {
                String string3 = (String)hashtable.get(string);
                if (string3.length() > 120) {
                    String string4 = AOUtil.getCN(string3);
                    if (string4 != null) {
                        hashtable.put(string, string4);
                        continue;
                    }
                    hashtable.put(string, string3.substring(0, 120 - "...".length()) + "...");
                    continue;
                }
                hashtable.put(string, string3.trim());
            }
        }
        return hashtable;
    }

    public static String getShort(String string) {
        if (string == null || !Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
            return string;
        }
        File file = new File(string);
        if (!file.exists()) {
            return string;
        }
        try {
            Process process = new ProcessBuilder("cmd.exe", "/c", "for %f in (\"" + string + "\") do @echo %~sf").start();
            return new String(AOUtil.getDataFromInputStream(process.getInputStream())).trim();
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido obtener el nombre corto de " + string + ": " + exception);
            return string;
        }
    }

    public static boolean addPreferredKeyStoreManagers(AggregatedKeyStoreManager aggregatedKeyStoreManager, Object object) {
        if (!Boolean.getBoolean(DISABLE_DNIE_NATIVE_DRIVER) && !Boolean.parseBoolean(System.getenv(DISABLE_DNIE_NATIVE_DRIVER_ENV))) {
            try {
                aggregatedKeyStoreManager.addKeyStoreManager(KeyStoreUtilities.getDnieKeyStoreManager(object));
                return true;
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                throw aOCancelledOperationException;
            }
            catch (Exception exception) {
                LOGGER.info("No se ha encontrado un DNIe: " + exception);
            }
        }
        if (!Boolean.getBoolean(DISABLE_CERES_NATIVE_DRIVER) && !Boolean.parseBoolean(System.getenv(DISABLE_CERES_NATIVE_DRIVER_ENV))) {
            try {
                aggregatedKeyStoreManager.addKeyStoreManager(KeyStoreUtilities.getCeres430KeyStoreManager(object));
                return true;
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                throw aOCancelledOperationException;
            }
            catch (Exception exception) {
                LOGGER.info("No se ha encontrado una tarjeta CERES 4.30 o superior: " + exception);
                try {
                    aggregatedKeyStoreManager.addKeyStoreManager(KeyStoreUtilities.getCeresKeyStoreManager(object));
                    return true;
                }
                catch (AOCancelledOperationException aOCancelledOperationException) {
                    throw aOCancelledOperationException;
                }
                catch (Exception exception2) {
                    LOGGER.info("No se ha encontrado una tarjeta CERES: " + exception2);
                }
            }
        }
        if (Boolean.getBoolean(ENABLE_GYDSC_NATIVE_DRIVER) || Boolean.parseBoolean(System.getenv(ENABLE_GYDSC_NATIVE_DRIVER_ENV))) {
            try {
                aggregatedKeyStoreManager.addKeyStoreManager(KeyStoreUtilities.getSmartCafeKeyStoreManager(object));
                return true;
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                throw aOCancelledOperationException;
            }
            catch (Exception exception) {
                LOGGER.info("No se ha encontrado una tarjeta G&D SmartCafe: " + exception);
            }
        }
        return false;
    }

    private static AOKeyStoreManager getDnieKeyStoreManager(Object object) throws AOKeystoreAlternativeException, IOException {
        AggregatedKeyStoreManager aggregatedKeyStoreManager = AOKeyStoreManagerFactory.getAOKeyStoreManager(AOKeyStore.DNIEJAVA, null, null, null, object);
        LOGGER.info("El DNIe 100% Java ha podido inicializarse, se anadiran sus entradas");
        aggregatedKeyStoreManager.setPreferred(true);
        return aggregatedKeyStoreManager;
    }

    private static AOKeyStoreManager getCeres430KeyStoreManager(Object object) throws AOKeystoreAlternativeException, IOException {
        AggregatedKeyStoreManager aggregatedKeyStoreManager = AOKeyStoreManagerFactory.getAOKeyStoreManager(AOKeyStore.CERES_430, null, null, null, object);
        LOGGER.info("La tarjeta CERES 430 ha podido inicializarse, se anadiran sus entradas");
        aggregatedKeyStoreManager.setPreferred(true);
        return aggregatedKeyStoreManager;
    }

    private static AOKeyStoreManager getCeresKeyStoreManager(Object object) throws AOKeystoreAlternativeException, IOException {
        AggregatedKeyStoreManager aggregatedKeyStoreManager = AOKeyStoreManagerFactory.getAOKeyStoreManager(AOKeyStore.CERES, null, null, null, object);
        LOGGER.info("La tarjeta CERES ha podido inicializarse, se anadiran sus entradas");
        aggregatedKeyStoreManager.setPreferred(true);
        return aggregatedKeyStoreManager;
    }

    private static AOKeyStoreManager getSmartCafeKeyStoreManager(Object object) throws AOKeystoreAlternativeException, IOException {
        AggregatedKeyStoreManager aggregatedKeyStoreManager = AOKeyStoreManagerFactory.getAOKeyStoreManager(AOKeyStore.SMARTCAFE, null, null, null, object);
        LOGGER.info("La tarjeta SmartCafe ha podido inicializarse, se anadiran sus entradas");
        aggregatedKeyStoreManager.setPreferred(true);
        return aggregatedKeyStoreManager;
    }

    public static KeyStore getKeyStoreWithPasswordCallbackHandler(AOKeyStore aOKeyStore, PasswordCallback passwordCallback, Provider provider, Object object) throws KeyStoreException {
        PasswordCallbackHandler passwordCallbackHandler = new PasswordCallbackHandler(object, passwordCallback);
        KeyStore.CallbackHandlerProtection callbackHandlerProtection = new KeyStore.CallbackHandlerProtection(passwordCallbackHandler);
        KeyStore.Builder builder = KeyStore.Builder.newInstance(aOKeyStore.getProviderName(), provider, callbackHandlerProtection);
        try {
            return builder.getKeyStore();
        }
        catch (KeyStoreException keyStoreException) {
            if (passwordCallbackHandler.isCancelled()) {
                LOGGER.warning("Se ha detectado la cancelacion del dialogo de PIN");
                throw new AOCancelledOperationException("Se cancelo el dialogo de insercion de PIN");
            }
            if (keyStoreException.getCause() != null && keyStoreException.getCause().getCause() != null && keyStoreException.getCause().getCause() instanceof LoginException) {
                Throwable throwable = keyStoreException.getCause().getCause().getCause();
                boolean bl = false;
                String string = KeyStoreMessages.getString("KeyStoreUtilities.5");
                if (throwable != null) {
                    if (PIN_ERROR_LOCKED.equals(throwable.getMessage())) {
                        string = KeyStoreMessages.getString("KeyStoreUtilities.7");
                        bl = true;
                    } else if (PIN_ERROR_WRONG_LENGTH.equals(throwable.getMessage())) {
                        string = KeyStoreMessages.getString("KeyStoreUtilities.8");
                    } else if (PIN_ERROR_INCORRECT.equals(throwable.getMessage())) {
                        string = KeyStoreMessages.getString("KeyStoreUtilities.5");
                    }
                }
                JOptionPane.showMessageDialog((Component)object, string, KeyStoreMessages.getString("KeyStoreUtilities.6"), 0);
                if (!bl) {
                    return KeyStoreUtilities.getKeyStoreWithPasswordCallbackHandler(aOKeyStore, passwordCallback, provider, object);
                }
            }
            throw keyStoreException;
        }
    }

    public static String searchPathForFile(String[] stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            return null;
        }
        if (new File(stringArray[0]).exists()) {
            return stringArray[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(Platform.getJavaLibraryPath(), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            for (String string2 : stringArray) {
                File file = new File(string, string2);
                if (!file.exists() || file.isDirectory()) continue;
                return string + string2;
            }
        }
        return null;
    }

    public static class PasswordCallbackHandler
    implements CallbackHandler {
        private final Object parentComponent;
        private final PasswordCallback pssCallBack;
        private boolean cancelled = false;

        public PasswordCallbackHandler(Object object, PasswordCallback passwordCallback) {
            this.parentComponent = object;
            this.pssCallBack = passwordCallback;
        }

        @Override
        public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
            for (Callback callback : callbackArray) {
                Object object;
                if (callback instanceof PasswordCallback) {
                    try {
                        ((PasswordCallback)callback).setPassword(this.pssCallBack.getPassword());
                    }
                    catch (AOCancelledOperationException aOCancelledOperationException) {
                        this.cancelled = true;
                    }
                    continue;
                }
                if (callback instanceof TextOutputCallback) {
                    object = (TextOutputCallback)callback;
                    switch (((TextOutputCallback)object).getMessageType()) {
                        case 0: {
                            LOGGER.info("Informacion del dispositivo criptografico: " + ((TextOutputCallback)object).getMessage());
                            AOUIFactory.showMessageDialog(this.parentComponent, ((TextOutputCallback)object).getMessage(), KeyStoreMessages.getString("KeyStoreUtilities.0"), 1);
                            break;
                        }
                        case 2: {
                            LOGGER.severe("Informacion del dispositivo criptografico: " + ((TextOutputCallback)object).getMessage());
                            AOUIFactory.showMessageDialog(this.parentComponent, ((TextOutputCallback)object).getMessage(), KeyStoreMessages.getString("KeyStoreUtilities.1"), 0);
                            break;
                        }
                        case 1: {
                            LOGGER.warning("Informacion del dispositivo criptografico: " + ((TextOutputCallback)object).getMessage());
                            AOUIFactory.showMessageDialog(this.parentComponent, ((TextOutputCallback)object).getMessage(), KeyStoreMessages.getString("KeyStoreUtilities.2"), 2);
                            break;
                        }
                        default: {
                            LOGGER.warning("Recibida informacion del dispositivo criptografico en un formato desconocido: " + ((TextOutputCallback)object).getMessageType());
                            break;
                        }
                    }
                    continue;
                }
                if (callback instanceof NameCallback) {
                    object = AOUIFactory.showInputDialog(this.parentComponent, KeyStoreMessages.getString("KeyStoreUtilities.3"), KeyStoreMessages.getString("KeyStoreUtilities.4"), 2, null, null, null);
                    if (object != null) {
                        ((NameCallback)callback).setName(object.toString());
                    }
                    throw new UnsupportedCallbackException(callback, "No se soporta la solicitud de nombre de usuario para dispositivos criptograficos");
                }
                throw new UnsupportedCallbackException(callback, "Recibido tipo de callback desconocido: " + callback.getClass().getName());
            }
        }

        public boolean isCancelled() {
            return this.cancelled;
        }
    }
}

