/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.callbacks.CachePasswordCallback;
import es.gob.afirma.keystores.callbacks.NullPasswordCallback;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.crypto.BadPaddingException;
import javax.security.auth.callback.PasswordCallback;

abstract class FileKeyStoreManager
extends AOKeyStoreManager {
    private PasswordCallback cachePasswordCallback;
    private String keystoreFile = null;

    FileKeyStoreManager() {
    }

    protected KeyStore init(InputStream inputStream, PasswordCallback passwordCallback) throws AOKeyStoreManagerException, IOException {
        KeyStore keyStore;
        if (inputStream == null) {
            throw new IllegalArgumentException("Es necesario proporcionar el fichero de almacen");
        }
        try {
            keyStore = KeyStore.getInstance(this.getType().getProviderName());
        }
        catch (Exception exception) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen de tipo " + (Object)((Object)this.getType()), exception);
        }
        this.cachePasswordCallback = passwordCallback != null ? new CachePasswordCallback(passwordCallback.getPassword()) : NullPasswordCallback.getInstance();
        try {
            keyStore.load(inputStream, this.cachePasswordCallback.getPassword());
        }
        catch (IOException iOException) {
            if (iOException.getCause() instanceof UnrecoverableKeyException || iOException.getCause() instanceof BadPaddingException || iOException.getCause() instanceof ArithmeticException) {
                throw new IOException("Contrasena invalida: " + iOException, iOException);
            }
            throw iOException;
        }
        catch (CertificateException certificateException) {
            throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen PKCS#12 / PFX solicitado: " + certificateException, certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen PKCS#12 / PFX solicitado: " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            LOGGER.warning("Error cerrando el almacen: " + exception);
        }
        return keyStore;
    }

    @Override
    public KeyStore.PrivateKeyEntry getKeyEntry(String string) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (this.lacksKeyStores()) {
            throw new IllegalStateException("Se han pedido claves a un almacen no inicializado");
        }
        PasswordCallback passwordCallback = this.getEntryPasswordCallBack();
        this.setEntryPasswordCallBack(this.cachePasswordCallback);
        try {
            return super.getKeyEntry(string);
        }
        catch (Exception exception) {
            LOGGER.warning("La contrasena del certificado no coincide con la del almacen: " + exception);
            this.setEntryPasswordCallBack(NullPasswordCallback.getInstance());
            try {
                return super.getKeyEntry(string);
            }
            catch (Exception exception2) {
                LOGGER.warning("La contrasena del certificado no es nula: " + exception2);
                this.setEntryPasswordCallBack(passwordCallback);
                return super.getKeyEntry(string);
            }
        }
    }

    protected void setKeyStoreFile(String string) {
        this.keystoreFile = string;
    }

    @Override
    public void refresh() throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(this.keystoreFile);){
            this.setKeyStore(this.init(fileInputStream, this.cachePasswordCallback));
        }
        catch (AOKeyStoreManagerException aOKeyStoreManagerException) {
            throw new IOException("Error al recargar el almacen PKCS#12: " + aOKeyStoreManagerException, aOKeyStoreManagerException);
        }
    }
}

