/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerFactory;
import es.gob.afirma.keystores.AOKeystoreAlternativeException;
import java.io.File;
import java.io.IOException;

final class FileBasedKeyStoreManagerFactory {
    private FileBasedKeyStoreManagerFactory() {
    }

    static AOKeyStoreManager getKeyStoreManager(File file, Object object) throws IOException, AOKeystoreAlternativeException {
        AOKeyStore aOKeyStore;
        if (file == null) {
            throw new IllegalArgumentException("El fichero de almacen no puede ser nulo");
        }
        if (!file.exists() || !file.isFile()) {
            throw new IOException("El fichero de almacen no existe");
        }
        if (!file.canRead()) {
            throw new IOException("El fichero de almacen no se puede leer");
        }
        String string = file.getName().toLowerCase();
        if (string.endsWith(".pfx") || string.endsWith(".p12")) {
            aOKeyStore = AOKeyStore.PKCS12;
        } else if (string.endsWith(".jks")) {
            aOKeyStore = AOKeyStore.JAVA;
        } else if (string.endsWith(".dll") || string.endsWith(".dylib") || string.endsWith(".so")) {
            aOKeyStore = AOKeyStore.PKCS11;
        } else {
            throw new IllegalArgumentException("No se soporta el tipo de fichero: " + file.getAbsolutePath());
        }
        return AOKeyStoreManagerFactory.getAOKeyStoreManager(aOKeyStore, file.getAbsolutePath(), "File", aOKeyStore.getStorePasswordCallback(object), object);
    }
}

