/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AggregatedKeyStoreManager;
import es.gob.afirma.keystores.CAPIKeyStoreManager;
import es.gob.afirma.keystores.KeyStoreUtilities;
import es.gob.afirma.keystores.SmartCardUnifiedKeyStoreManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.security.auth.callback.PasswordCallback;

public class CAPIUnifiedKeyStoreManager
extends AggregatedKeyStoreManager {
    private static final String SYSTEM_PROPERTY_USERNAME = "user.name";
    private static final String ENVIRONMENT_PROPERTY_USERPROFILE = "USERPROFILE";
    private static final String TEMPORARY_PROFILE_NAME = "TEMP";
    private PasswordCallback passwordCallback = null;
    private Object[] configParams = null;
    private boolean initialized = false;

    public CAPIUnifiedKeyStoreManager() {
        this.setKeyStoreType(AOKeyStore.WINDOWS);
    }

    @Override
    public final void init(AOKeyStore aOKeyStore, InputStream inputStream, PasswordCallback passwordCallback, Object[] objectArray, boolean bl) {
        this.passwordCallback = passwordCallback;
        this.configParams = objectArray;
        this.removeAll();
        Object object = objectArray != null && objectArray.length > 0 ? objectArray[0] : null;
        CAPIKeyStoreManager cAPIKeyStoreManager = null;
        boolean bl2 = CAPIUnifiedKeyStoreManager.isTemporaryProfile();
        if (bl2) {
            LOGGER.info("Detectado perfil temporal. Se omitira la carga del almacen de Windows y se buscaran tarjetas conocidas insertadas");
        } else {
            cAPIKeyStoreManager = new CAPIKeyStoreManager();
            try {
                ((AOKeyStoreManager)cAPIKeyStoreManager).init(aOKeyStore, inputStream, passwordCallback, objectArray, bl);
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido cargar el almacen de Windows, se continuara con los almacenes preferentes: " + exception);
            }
            this.addKeyStoreManager(cAPIKeyStoreManager);
        }
        boolean bl3 = false;
        if (bl || !this.initialized) {
            try {
                bl3 = KeyStoreUtilities.addPreferredKeyStoreManagers(this, object);
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                LOGGER.info("Se cancelo el uso del driver Java: " + aOCancelledOperationException);
                bl3 = true;
            }
        }
        if (!bl3 && bl2) {
            SmartCardUnifiedKeyStoreManager smartCardUnifiedKeyStoreManager = new SmartCardUnifiedKeyStoreManager();
            try {
                ((AOKeyStoreManager)smartCardUnifiedKeyStoreManager).init(aOKeyStore, inputStream, passwordCallback, objectArray, bl);
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido cargar el almacen unificado de tarjetas: " + exception);
            }
            this.addKeyStoreManager(smartCardUnifiedKeyStoreManager);
        }
        if (cAPIKeyStoreManager != null && !bl3) {
            try {
                cAPIKeyStoreManager.refresh();
            }
            catch (IOException iOException) {
                LOGGER.warning("Error al refrescar el almacen de claves de Windows: " + iOException);
            }
        }
        this.initialized = true;
    }

    @Override
    public void refresh() throws IOException {
        this.init(AOKeyStore.WINDOWS, null, this.passwordCallback, this.configParams, true);
    }

    private static boolean isTemporaryProfile() {
        String string = System.getProperty(SYSTEM_PROPERTY_USERNAME);
        String string2 = System.getenv(ENVIRONMENT_PROPERTY_USERPROFILE);
        if (string == null || string2 == null) {
            LOGGER.warning("No se ha podido identificar el nombre de usuario o su directorio de perfil. No se comprobara si se trata de un perfil temporal");
            return false;
        }
        String string3 = new File(string2).getName();
        return !string.equals(string3) && (TEMPORARY_PROFILE_NAME.equals(string3) || string3.startsWith("TEMP."));
    }
}

