/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.InvalidOSException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.KeyStoreMessages;
import es.gob.afirma.keystores.KeyStoreUtilities;
import es.gob.afirma.keystores.MissingSunMSCAPIException;
import es.gob.afirma.keystores.callbacks.FirstEmptyThenPinUiPasswordCallback;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import javax.security.auth.callback.PasswordCallback;

public final class CAPIKeyStoreManager
extends AOKeyStoreManager {
    private static KeyStore capiKsMy = null;

    CAPIKeyStoreManager() {
        this.setKeyStoreType(AOKeyStore.WINDOWS);
    }

    @Override
    public KeyStore.PrivateKeyEntry getKeyEntry(String string) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        if (capiKsMy == null) {
            throw new IllegalStateException("Se han pedido claves a un almacen no inicializado");
        }
        return (KeyStore.PrivateKeyEntry)capiKsMy.getEntry(string, new KeyStore.PasswordProtection("dummy".toCharArray()));
    }

    @Override
    public void init(AOKeyStore aOKeyStore, InputStream inputStream, PasswordCallback passwordCallback, Object[] objectArray, boolean bl) throws AOKeyStoreManagerException {
        this.resetCachedAliases();
        if (AOKeyStore.WINDOWS.equals((Object)aOKeyStore)) {
            if (bl) {
                capiKsMy = null;
            }
        } else {
            throw new AOKeyStoreManagerException("Tipo de almacen no soportado, este gestor es exclusivo CAPI: " + aOKeyStore.getName());
        }
        this.setKeyStore(CAPIKeyStoreManager.initCapi());
    }

    private static KeyStore initCapi() throws AOKeyStoreManagerException {
        if (capiKsMy == null) {
            if (!Platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
                throw new InvalidOSException("Microsoft Windows");
            }
            Provider provider = Security.getProvider("SunMSCAPI");
            if (provider == null) {
                try {
                    provider = (Provider)Class.forName("sun.security.mscapi.SunMSCAPI").getConstructor(new Class[0]).newInstance(new Object[0]);
                    Security.addProvider(provider);
                }
                catch (Exception exception) {
                    LOGGER.severe("No se ha podido instanciar 'sun.security.mscapi.SunMSCAPI': " + exception);
                    throw new MissingSunMSCAPIException(exception);
                }
            }
            try {
                capiKsMy = KeyStoreUtilities.getKeyStoreWithPasswordCallbackHandler(AOKeyStore.WINDOWS, new FirstEmptyThenPinUiPasswordCallback(KeyStoreMessages.getString("CAPIKeyStoreManager.0")), provider, null);
            }
            catch (AOCancelledOperationException aOCancelledOperationException) {
                throw aOCancelledOperationException;
            }
            catch (Exception exception) {
                throw new AOKeyStoreManagerException("No se ha podido obtener el almacen Windows.MY: " + exception, exception);
            }
            try {
                CAPIKeyStoreManager.cleanCAPIDuplicateAliases(capiKsMy);
            }
            catch (Exception exception) {
                LOGGER.warning("No se han podido tratar los alias duplicados: " + exception);
            }
        }
        return capiKsMy;
    }

    @Override
    public X509Certificate getCertificate(String string) {
        if (string == null) {
            LOGGER.warning("El alias del certificado es nulo, se devolvera null");
            return null;
        }
        if (capiKsMy == null) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + string + "' porque el KeyStore no estaba inicializado, se devolvera null");
            return null;
        }
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = (X509Certificate)capiKsMy.getCertificate(string);
        }
        catch (Exception exception) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + string + "', se devolvera null: " + exception);
            return null;
        }
        if (x509Certificate == null) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + string + "', se devolvera null");
            return null;
        }
        return x509Certificate;
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        if (capiKsMy == null) {
            LOGGER.warning("El KeyStore actual no esta inicializado, por lo que no se pudo recuperar el certificado para el alias '" + string + "'");
            return null;
        }
        try {
            return (X509Certificate[])capiKsMy.getCertificateChain(string);
        }
        catch (Exception exception) {
            LOGGER.severe("Error al obtener la cadena de certificados para el alias '" + string + "', se devolvera una cadena vacia: " + exception);
            return new X509Certificate[0];
        }
    }

    @Override
    public String[] getAliases() {
        if (capiKsMy == null) {
            throw new IllegalStateException("Se han pedido los alias de un almacen no inicializado");
        }
        if (this.getCachedAliases() != null) {
            return this.getCachedAliases();
        }
        LOGGER.info("Solicitando los alias al KeyStore (" + capiKsMy.getProvider() + ")");
        try {
            this.setCachedAliases(this.cleanDeactivatedAliases(Collections.list(capiKsMy.aliases()).toArray(new String[0])));
        }
        catch (Exception exception) {
            LOGGER.severe("Error intentando obtener los alias del almacen de claves, se devolvera una enumeracion vacia: " + exception);
            return new String[0];
        }
        return this.getCachedAliases();
    }

    @Override
    public String toString() {
        return "Gestor del almacen Windows.MY de CAPI via SunMSCAPI";
    }

    private static void cleanCAPIDuplicateAliases(KeyStore keyStore) throws NoSuchFieldException, IllegalAccessException {
        if (AOUtil.isJava9orNewer()) {
            return;
        }
        Field field = keyStore.getClass().getDeclaredField("keyStoreSpi");
        field.setAccessible(true);
        KeyStoreSpi keyStoreSpi = (KeyStoreSpi)field.get(keyStore);
        if ("sun.security.mscapi.KeyStore$MY".equals(keyStoreSpi.getClass().getName())) {
            field = keyStoreSpi.getClass().getEnclosingClass().getDeclaredField("entries");
            field.setAccessible(true);
            Object object = field.get(keyStoreSpi);
            if (object instanceof Collection) {
                Collection collection = (Collection)field.get(keyStoreSpi);
                for (Object e : collection) {
                    field = e.getClass().getDeclaredField("certChain");
                    field.setAccessible(true);
                    X509Certificate[] x509CertificateArray = (X509Certificate[])field.get(e);
                    String string = Integer.toString(x509CertificateArray[0].hashCode());
                    field = e.getClass().getDeclaredField("alias");
                    field.setAccessible(true);
                    String string2 = (String)field.get(e);
                    if (string2.equals(string)) continue;
                    field.set(e, string2.concat(" - ").concat(string));
                }
            }
        }
    }
}

