/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.InvalidOSException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import javax.security.auth.callback.PasswordCallback;

final class AppleKeyStoreManager
extends AOKeyStoreManager {
    AppleKeyStoreManager() {
        this.setKeyStoreType(AOKeyStore.APPLE);
    }

    @Override
    public void init(AOKeyStore aOKeyStore, InputStream inputStream, PasswordCallback passwordCallback, Object[] objectArray, boolean bl) throws AOKeyStoreManagerException, IOException {
        this.setKeyStore(AppleKeyStoreManager.initApple(inputStream));
        this.getAliasesWithoutDuplicates();
    }

    @Override
    public KeyStore.PrivateKeyEntry getKeyEntry(String string) throws KeyStoreException {
        if (this.getKeyStore() == null) {
            throw new IllegalStateException("Se han pedido claves a un almacen no inicializado");
        }
        if (string == null) {
            throw new IllegalArgumentException("El alias no puede ser nulo");
        }
        if (this.getKeyStore().containsAlias(string)) {
            PrivateKey privateKey = null;
            try {
                LOGGER.info("Llavero de Mac OS X, se tratan directamente las claves privadas");
                privateKey = (PrivateKey)this.getKeyStore().getKey(string, "dummy".toCharArray());
            }
            catch (Exception exception) {
                LOGGER.warning("Error recuperando directamente la clave privada en Mac OS X: " + exception);
            }
            if (privateKey == null) {
                throw new UnsupportedOperationException("La entrada no tiene clave privada");
            }
            return new KeyStore.PrivateKeyEntry(privateKey, this.getCertificateChain(string));
        }
        LOGGER.warning("El almacen no contiene ninguna clave con el alias '" + string + "', se devolvera null");
        return null;
    }

    private static KeyStore initApple(InputStream inputStream) throws AOKeyStoreManagerException, IOException {
        KeyStore keyStore;
        if (!Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            throw new InvalidOSException("Apple Mac OS X");
        }
        try {
            keyStore = KeyStore.getInstance(AOKeyStore.APPLE.getProviderName());
        }
        catch (Exception exception) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen Apple.KeychainStore", exception);
        }
        try {
            keyStore.load(inputStream, null);
        }
        catch (CertificateException certificateException) {
            throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen Apple.KeychainStore", certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen Apple.KeychainStore", noSuchAlgorithmException);
        }
        return keyStore;
    }

    private void getAliasesWithoutDuplicates() throws AOKeyStoreManagerException {
        Object object;
        Enumeration<String> enumeration;
        try {
            enumeration = this.getKeyStore().aliases();
        }
        catch (KeyStoreException keyStoreException) {
            throw new AOKeyStoreManagerException("Error obteniendo los alias: " + keyStoreException, keyStoreException);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            try {
                if (!this.getKeyStore().isKeyEntry((String)object)) continue;
                arrayList.add(object);
            }
            catch (KeyStoreException keyStoreException) {
                LOGGER.info("Se ignora el certificado '" + (String)object + "' por no poderse operar con su clave privada: " + keyStoreException);
            }
        }
        object = new ArrayList();
        HashSet<BigInteger> hashSet = new HashSet<BigInteger>();
        for (String string : arrayList) {
            X509Certificate x509Certificate = this.getCertificate(string);
            if (!hashSet.contains(x509Certificate.getSerialNumber())) {
                hashSet.add(x509Certificate.getSerialNumber());
                object.add(string);
                continue;
            }
            LOGGER.info("Retirado certificado '" + AOUtil.getCN(x509Certificate) + "' (serie=" + x509Certificate.getSerialNumber() + ") por estar duplicado");
        }
        this.setCachedAliases(object.toArray(new String[object.size()]));
    }
}

