/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AggregatedKeyStoreManager
extends AOKeyStoreManager {
    private final List<AOKeyStoreManager> ksms = new ArrayList<AOKeyStoreManager>();

    AggregatedKeyStoreManager(AOKeyStoreManager aOKeyStoreManager) {
        if (aOKeyStoreManager == null) {
            throw new IllegalArgumentException("El gestor principal de almacenes no puede ser nulo");
        }
        this.addKeyStoreManager(aOKeyStoreManager);
        this.setKeyStoreType(aOKeyStoreManager.getType());
    }

    protected AggregatedKeyStoreManager() {
    }

    @Override
    protected AOKeyStore getType(String string) {
        for (AOKeyStoreManager aOKeyStoreManager : this.ksms) {
            if (aOKeyStoreManager.getCertificate(string) == null) continue;
            return aOKeyStoreManager.getType(string);
        }
        LOGGER.warning("Se ha pedido el tipo de almacen de un alias no contenido en este gestor, se devolvera el tipo por defecto");
        return this.getType();
    }

    public final void addKeyStoreManager(AOKeyStoreManager aOKeyStoreManager) {
        if (aOKeyStoreManager != null) {
            if (aOKeyStoreManager.isPreferred()) {
                String[] stringArray = aOKeyStoreManager.getAliases();
                MessageDigest messageDigest = null;
                try {
                    messageDigest = MessageDigest.getInstance("SHA1");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    LOGGER.warning("No se ha podido instanciar el generador de huellas digitales SHA1, pueden aparecer duplicados en la lista de certificados: " + noSuchAlgorithmException);
                }
                if (messageDigest != null) {
                    for (String string : stringArray) {
                        String string2;
                        try {
                            string2 = AOUtil.hexify(messageDigest.digest(aOKeyStoreManager.getCertificate(string).getEncoded()), false);
                        }
                        catch (CertificateEncodingException certificateEncodingException) {
                            LOGGER.severe("No se ha podido obtener la huella del certificado '" + string + "', pueden aparecer duplicados en la lista de certificados: " + certificateEncodingException);
                            continue;
                        }
                        LOGGER.info("El certificado de huella '" + string2 + "' se tomara unicamente del almacen preferente");
                        for (AOKeyStoreManager aOKeyStoreManager2 : this.ksms) {
                            aOKeyStoreManager2.deactivateEntry(string2);
                        }
                    }
                }
            }
            this.ksms.add(aOKeyStoreManager);
        }
    }

    @Override
    public String[] getAliases() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AOKeyStoreManager aOKeyStoreManager : this.ksms) {
            try {
                arrayList.addAll(Arrays.asList(aOKeyStoreManager.getAliases()));
            }
            catch (Exception exception) {
                LOGGER.warning("No se pudieron obtener los alias del almacen " + (Object)((Object)aOKeyStoreManager.getType()) + ": " + exception);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public X509Certificate getCertificate(String string) {
        for (AOKeyStoreManager aOKeyStoreManager : this.ksms) {
            List<String> list;
            try {
                list = Arrays.asList(aOKeyStoreManager.getAliases());
            }
            catch (Exception exception) {
                LOGGER.warning("No se pudieron obtener los alias del almacen " + (Object)((Object)aOKeyStoreManager.getType()) + ": " + exception);
                continue;
            }
            if (!list.contains(string)) continue;
            return aOKeyStoreManager.getCertificate(string);
        }
        LOGGER.warning("El almacen no contiene ningun certificado con alias '" + string + "', se devolvera null");
        return null;
    }

    @Override
    public KeyStore.PrivateKeyEntry getKeyEntry(String string) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        for (AOKeyStoreManager aOKeyStoreManager : this.ksms) {
            List<String> list;
            try {
                list = Arrays.asList(aOKeyStoreManager.getAliases());
            }
            catch (Exception exception) {
                LOGGER.warning("No se pudieron obtener los alias del almacen " + (Object)((Object)aOKeyStoreManager.getType()) + ": " + exception);
                continue;
            }
            if (!list.contains(string)) continue;
            return aOKeyStoreManager.getKeyEntry(string);
        }
        LOGGER.warning("El almacen no contiene ninguna clave con alias '" + string + "', se devolvera null");
        return null;
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        for (AOKeyStoreManager aOKeyStoreManager : this.ksms) {
            List<String> list;
            try {
                list = Arrays.asList(aOKeyStoreManager.getAliases());
            }
            catch (Exception exception) {
                LOGGER.warning("No se pudieron obtener los alias del almacen " + (Object)((Object)aOKeyStoreManager.getType()) + ": " + exception);
                continue;
            }
            if (!list.contains(string)) continue;
            return aOKeyStoreManager.getCertificateChain(string);
        }
        LOGGER.warning("El almacen no contiene ninguna cadena de certificados con alias '" + string + "', se devolvera null");
        return null;
    }

    @Override
    public void refresh() throws IOException {
        for (AOKeyStoreManager aOKeyStoreManager : this.ksms) {
            try {
                aOKeyStoreManager.refresh();
            }
            catch (Exception exception) {
                aOKeyStoreManager.setKeyStore(null);
                LOGGER.warning("Error al actualizar el almacen de tipo " + (Object)((Object)aOKeyStoreManager.getType()) + ": " + exception);
            }
        }
    }

    @Override
    protected boolean lacksKeyStores() {
        return this.ksms.isEmpty();
    }

    @Override
    public boolean isKeyEntry(String string) throws KeyStoreException {
        for (AOKeyStoreManager aOKeyStoreManager : this.ksms) {
            List<String> list;
            try {
                list = Arrays.asList(aOKeyStoreManager.getAliases());
            }
            catch (Exception exception) {
                LOGGER.warning("No se pudieron obtener los alias del almacen " + (Object)((Object)aOKeyStoreManager.getType()) + ": " + exception);
                continue;
            }
            if (!list.contains(string)) continue;
            return aOKeyStoreManager.isKeyEntry(string);
        }
        throw new KeyStoreException("Se ha pedido comprobar la clave privada de un certificado no contenido en este gestor");
    }

    List<AOKeyStoreManager> getKeyStoreManagers() {
        return (List)((ArrayList)this.ksms).clone();
    }

    public void removeAll() {
        this.ksms.clear();
    }
}

