/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.MissingLibraryException;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.crypto.BadPaddingException;
import javax.security.auth.callback.PasswordCallback;

final class AOKeyStoreManagerHelperSingle {
    private AOKeyStoreManagerHelperSingle() {
    }

    static KeyStore initSingle(InputStream inputStream, PasswordCallback passwordCallback) throws AOKeyStoreManagerException, IOException {
        KeyStore keyStore;
        Provider provider;
        if (inputStream == null) {
            throw new AOKeyStoreManagerException("Es necesario proporcionar el fichero X.509 o PKCS#7");
        }
        try {
            provider = (Provider)Class.forName("es.gob.afirma.keystores.single.SingleCertKeyStoreProvider").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new MissingLibraryException("No se ha podido instanciar el proveedor SingleCertKeyStoreProvider: " + exception, exception);
        }
        Security.addProvider(provider);
        try {
            keyStore = KeyStore.getInstance(AOKeyStore.SINGLE.getProviderName(), provider);
        }
        catch (Exception exception) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen PKCS#7 / X.509", exception);
        }
        try {
            keyStore.load(inputStream, passwordCallback != null ? passwordCallback.getPassword() : null);
        }
        catch (IOException iOException) {
            if (iOException.getCause() instanceof UnrecoverableKeyException || iOException.getCause() instanceof BadPaddingException) {
                throw new IOException("Contrasena invalida: " + iOException, iOException);
            }
            throw new AOKeyStoreManagerException("No se ha podido abrir el almacen PKCS#7 / X.509 solicitado", iOException);
        }
        catch (CertificateException certificateException) {
            throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen PKCS#7 / X.509 solicitado", certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen PKCS#7 / X.509 solicitado", noSuchAlgorithmException);
        }
        return keyStore;
    }
}

