/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.KeyStoreUtilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

final class AOKeyStoreManagerHelperPkcs11 {
    static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private AOKeyStoreManagerHelperPkcs11() {
    }

    static KeyStore initPKCS11(PasswordCallback passwordCallback, Object[] objectArray, boolean bl, Object object) throws AOKeyStoreManagerException, IOException {
        if (objectArray == null || objectArray.length < 2) {
            throw new IOException("No se puede acceder al KeyStore PKCS#11 si no se especifica la biblioteca");
        }
        if (objectArray[0] == null) {
            throw new IllegalArgumentException("No se puede acceder al KeyStore PKCS#11 si se especifica una biblioteca nula");
        }
        String string = objectArray[0].toString();
        Integer n = null;
        if (objectArray.length >= 3 && objectArray[2] instanceof Integer) {
            n = (Integer)objectArray[2];
        }
        String string2 = new File(string).getName().replace('.', '_').replace(' ', '_');
        Provider provider = Security.getProvider("SunPKCS11-" + string2);
        if (provider != null && (bl || Boolean.getBoolean("es.gob.afirma.keystores.DoNotReusePkcs11Provider"))) {
            LOGGER.info("Se retira el proveedor " + provider);
            Security.removeProvider(provider.getName());
            provider = null;
        }
        if (provider == null) {
            byte[] byArray = KeyStoreUtilities.createPKCS11ConfigFile(string, string2, n).getBytes();
            try {
                provider = AOKeyStoreManagerHelperPkcs11.getP11Provider(byArray);
            }
            catch (Exception exception) {
                LOGGER.warning("Ha fallado el primer intento de inicializacion del PKCS#11 para la la biblioteca '" + string + "', se reintentara: " + exception);
                try {
                    provider = AOKeyStoreManagerHelperPkcs11.getP11Provider(byArray);
                }
                catch (Exception exception2) {
                    throw new AOKeyStoreManagerException("No se ha podido instanciar el proveedor SunPKCS11 para la la biblioteca '" + string + "': " + exception2, exception2);
                }
            }
        } else {
            LOGGER.info("El proveedor SunPKCS11 solicitado ya estaba instanciado, se reutilizara esa instancia: " + provider.getName());
        }
        if (passwordCallback == null) {
            return AOKeyStoreManagerHelperPkcs11.getKeyStoreWithNullPassword(provider);
        }
        try {
            return KeyStoreUtilities.getKeyStoreWithPasswordCallbackHandler(AOKeyStore.PKCS11, passwordCallback, provider, object);
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            Security.removeProvider("SunPKCS11-" + string2);
            throw aOCancelledOperationException;
        }
        catch (Exception exception) {
            Security.removeProvider("SunPKCS11-" + string2);
            throw new AOKeyStoreManagerException("Error construyendo el KeyStore PKCS#11 para la biblioteca '" + string + "': " + exception, exception);
        }
    }

    private static KeyStore getKeyStoreWithNullPassword(Provider provider) throws AOKeyStoreManagerException {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(AOKeyStore.PKCS11.getProviderName(), provider);
        }
        catch (Exception exception) {
            Security.removeProvider(provider.getName());
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen PKCS#11: " + exception, exception);
        }
        try {
            keyStore.load(null, null);
        }
        catch (IOException iOException) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen PKCS#11 solicitado: " + iOException, iOException);
        }
        catch (CertificateException certificateException) {
            Security.removeProvider(provider.getName());
            throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen PKCS#11 solicitado: " + certificateException, certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Security.removeProvider(provider.getName());
            throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen PKCS#11 solicitado: " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        return keyStore;
    }

    private static Provider getP11Provider(byte[] byArray) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException, ClassNotFoundException, IOException {
        return AOUtil.isJava9orNewer() ? AOKeyStoreManagerHelperPkcs11.getP11ProviderJava9(byArray) : AOKeyStoreManagerHelperPkcs11.getP11ProviderJava8(byArray);
    }

    private static Provider getP11ProviderJava9(byte[] byArray) throws IOException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Provider provider = Security.getProvider("SunPKCS11");
        File file = File.createTempFile("pkcs11_", ".cfg");
        Serializable serializable = null;
        try (Object object = new FileOutputStream(file);){
            ((OutputStream)object).write(byArray);
            ((OutputStream)object).close();
        }
        catch (Throwable throwable) {
            serializable = throwable;
            throw throwable;
        }
        object = Provider.class.getMethod("configure", String.class);
        serializable = (Provider)((Method)object).invoke((Object)provider, file.getAbsolutePath());
        file.deleteOnExit();
        Security.addProvider((Provider)serializable);
        return serializable;
    }

    private static Provider getP11ProviderJava8(byte[] byArray) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        Provider provider = (Provider)Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class).newInstance(new ByteArrayInputStream(byArray));
        Security.addProvider(provider);
        return provider;
    }
}

