/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.crypto.BadPaddingException;
import javax.security.auth.callback.PasswordCallback;

final class AOKeyStoreManagerHelperJava {
    private AOKeyStoreManagerHelperJava() {
    }

    static KeyStore initJava(InputStream inputStream, PasswordCallback passwordCallback, AOKeyStore aOKeyStore) throws AOKeyStoreManagerException, IOException {
        KeyStore keyStore;
        if (inputStream == null) {
            throw new IOException("Es necesario proporcionar el fichero KeyStore");
        }
        try {
            keyStore = KeyStore.getInstance(aOKeyStore.getProviderName());
        }
        catch (Exception exception) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen JavaKeyStore", exception);
        }
        try {
            keyStore.load(inputStream, passwordCallback != null ? passwordCallback.getPassword() : null);
        }
        catch (IOException iOException) {
            if (iOException.getCause() instanceof UnrecoverableKeyException || iOException.getCause() instanceof BadPaddingException) {
                throw new IOException("Contrasena invalida: " + iOException, iOException);
            }
            throw iOException;
        }
        catch (CertificateException certificateException) {
            throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen JavaKeyStore solicitado", certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen JavaKeyStore solicitado", noSuchAlgorithmException);
        }
        return keyStore;
    }
}

