/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.jmulticard.jse.provider.Ceres430Provider;
import es.gob.jmulticard.jse.provider.DnieProvider;
import es.gob.jmulticard.jse.provider.ceres.CeresProvider;
import es.gob.jmulticard.jse.provider.gide.SmartCafeProvider;
import es.gob.jmulticard.ui.passwordcallback.PasswordCallbackManager;
import es.gob.jmulticard.ui.passwordcallback.gui.DnieCacheCallbackHandler;
import es.gob.jmulticard.ui.passwordcallback.gui.SmartcardCacheCallbackHandler;
import es.gob.jmulticard.ui.passwordcallback.gui.SmartcardCallbackHandler;
import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;

final class AOKeyStoreManagerHelperFullJava {
    protected static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private AOKeyStoreManagerHelperFullJava() {
    }

    static KeyStore initCeresJava(Object object) throws AOKeyStoreManagerException, IOException {
        return AOKeyStoreManagerHelperFullJava.init(AOKeyStore.CERES, AOKeyStoreManagerHelperFullJava.buildLoadStoreParameter(new SmartcardCacheCallbackHandler()), new CeresProvider(), object);
    }

    static KeyStore initCeres430Java(Object object) throws AOKeyStoreManagerException, IOException {
        return AOKeyStoreManagerHelperFullJava.init(AOKeyStore.CERES_430, AOKeyStoreManagerHelperFullJava.buildLoadStoreParameter(new SmartcardCacheCallbackHandler()), new Ceres430Provider(), object);
    }

    static KeyStore initSmartCafeJava(Object object) throws AOKeyStoreManagerException, IOException {
        return AOKeyStoreManagerHelperFullJava.init(AOKeyStore.SMARTCAFE, AOKeyStoreManagerHelperFullJava.buildLoadStoreParameter(new SmartcardCallbackHandler()), new SmartCafeProvider(), object);
    }

    static KeyStore initDnieJava(Object object) throws AOKeyStoreManagerException, IOException {
        return AOKeyStoreManagerHelperFullJava.init(AOKeyStore.DNIEJAVA, AOKeyStoreManagerHelperFullJava.buildLoadStoreParameter(new DnieCacheCallbackHandler()), new DnieProvider(), object);
    }

    private static KeyStore init(AOKeyStore aOKeyStore, KeyStore.LoadStoreParameter loadStoreParameter, Provider provider, Object object) throws AOKeyStoreManagerException, IOException {
        KeyStore keyStore;
        if (Security.getProvider(provider.getName()) == null) {
            Security.addProvider(provider);
        }
        PasswordCallbackManager.setDialogOwner(object);
        try {
            keyStore = KeyStore.getInstance(aOKeyStore.getProviderName());
        }
        catch (Exception exception) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen 100% Java para " + aOKeyStore.toString() + ": " + exception, exception);
        }
        LOGGER.info("Cargando KeyStore 100% Java para " + aOKeyStore.toString());
        try {
            keyStore.load(loadStoreParameter);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOKeyStoreManagerException("Error de algoritmo al obtener el almacen 100% Java para " + aOKeyStore.toString() + ": " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new AOKeyStoreManagerException("Error de certificado al obtener el almacen 100% Java para " + aOKeyStore.toString() + ": " + certificateException, certificateException);
        }
        return keyStore;
    }

    private static KeyStore.LoadStoreParameter buildLoadStoreParameter(final CallbackHandler callbackHandler) {
        return new KeyStore.LoadStoreParameter(){

            @Override
            public KeyStore.ProtectionParameter getProtectionParameter() {
                return new KeyStore.CallbackHandlerProtection(callbackHandler);
            }
        };
    }
}

