/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.InvalidOSException;
import es.gob.afirma.core.MissingLibraryException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.MissingSunMSCAPIException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.logging.Logger;

final class AOKeyStoreManagerHelperCapiAddressBook {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private AOKeyStoreManagerHelperCapiAddressBook() {
    }

    static KeyStore initCAPIAddressBook(AOKeyStore aOKeyStore) throws AOKeyStoreManagerException {
        KeyStore keyStore;
        Provider provider;
        if (!Platform.getOS().equals((Object)Platform.OS.WINDOWS)) {
            throw new InvalidOSException("Microsoft Windows");
        }
        if (Security.getProvider("SunMSCAPI") == null) {
            try {
                Security.addProvider((Provider)Class.forName("sun.security.mscapi.SunMSCAPI").getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido instanciar 'sun.security.mscapi.SunMSCAPI': " + exception);
                throw new MissingSunMSCAPIException(exception);
            }
        }
        if ((provider = Security.getProvider("MSCAPIAddressBook")) == null) {
            try {
                provider = (Provider)Class.forName("es.gob.afirma.keystores.capiaddressbook.MSCAPIAddressBook").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new MissingLibraryException("No se ha podido instanciar el proveedor MSCAPIAddressBook", exception);
            }
            Security.addProvider(provider);
        }
        try {
            keyStore = KeyStore.getInstance(aOKeyStore.getProviderName(), provider);
        }
        catch (Exception exception) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen " + aOKeyStore.getProviderName() + ": " + exception, exception);
        }
        try {
            keyStore.load(null, null);
        }
        catch (Exception exception) {
            throw new AOKeyStoreManagerException("No se ha podido abrir el almacen " + aOKeyStore.getProviderName() + ": " + exception, exception);
        }
        return keyStore;
    }
}

