/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.InvalidOSException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

final class AOKeyStoreManagerHelperApple {
    private AOKeyStoreManagerHelperApple() {
    }

    static KeyStore initApple(InputStream inputStream) throws AOKeyStoreManagerException, IOException {
        KeyStore keyStore;
        if (!Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
            throw new InvalidOSException("Apple macOS");
        }
        try {
            keyStore = KeyStore.getInstance(AOKeyStore.APPLE.getProviderName());
        }
        catch (Exception exception) {
            throw new AOKeyStoreManagerException("No se ha podido obtener el almacen Apple.KeychainStore", exception);
        }
        try {
            keyStore.load(inputStream, null);
        }
        catch (CertificateException certificateException) {
            throw new AOKeyStoreManagerException("No se han podido cargar los certificados del almacen Apple.KeychainStore", certificateException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOKeyStoreManagerException("No se ha podido verificar la integridad del almacen Apple.KeychainStore", noSuchAlgorithmException);
        }
        return keyStore;
    }
}

