/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.AOKeystoreAlternativeException;
import es.gob.afirma.keystores.AggregatedKeyStoreManager;
import es.gob.afirma.keystores.AppleKeyStoreManager;
import es.gob.afirma.keystores.CAPIUnifiedKeyStoreManager;
import es.gob.afirma.keystores.JavaKeyStoreManager;
import es.gob.afirma.keystores.KeyStoreMessages;
import es.gob.afirma.keystores.KeyStoreUtilities;
import es.gob.afirma.keystores.Pkcs12KeyStoreManager;
import es.gob.afirma.keystores.callbacks.NullPasswordCallback;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

public final class AOKeyStoreManagerFactory {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    public static final String FORCE_STORE_RESET = "es.gob.afirma.keystores.ForceReset";
    private static AggregatedKeyStoreManager mozillaKeyStoreManager = null;

    private AOKeyStoreManagerFactory() {
    }

    public static AggregatedKeyStoreManager getAOKeyStoreManager(AOKeyStore aOKeyStore, String string, String string2, PasswordCallback passwordCallback, Object object) throws AOKeystoreAlternativeException, IOException {
        boolean bl;
        try {
            bl = Boolean.getBoolean(FORCE_STORE_RESET);
        }
        catch (Exception exception) {
            bl = false;
            LOGGER.warning("No se ha podido leer la variable 'es.gob.afirma.keystores.ForceReset', se usara 'false' como valor por defecto: " + exception);
        }
        if (bl) {
            LOGGER.info("No se mantendran los almacenes de claves precargados (es.gob.afirma.keystores.ForceReset=true)");
        }
        if (AOKeyStore.PKCS12.equals((Object)aOKeyStore)) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getPkcs12KeyStoreManager(string, passwordCallback, bl, object));
        }
        if (AOKeyStore.JAVA.equals((Object)aOKeyStore)) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getJavaKeyStoreManager(string, passwordCallback, bl, object));
        }
        if (AOKeyStore.SINGLE.equals((Object)aOKeyStore) || AOKeyStore.JAVACE.equals((Object)aOKeyStore) || AOKeyStore.JCEKS.equals((Object)aOKeyStore)) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getFileKeyStoreManager(aOKeyStore, string, passwordCallback, bl, object));
        }
        if (AOKeyStore.PKCS11.equals((Object)aOKeyStore)) {
            AOKeyStoreManager aOKeyStoreManager = AOKeyStoreManagerFactory.getPkcs11KeyStoreManager(string, string2, passwordCallback, bl, object);
            AggregatedKeyStoreManager aggregatedKeyStoreManager = new AggregatedKeyStoreManager(aOKeyStoreManager);
            aggregatedKeyStoreManager.setKeyStore(aOKeyStoreManager.getKeyStore());
            return aggregatedKeyStoreManager;
        }
        if (Platform.getOS().equals((Object)Platform.OS.WINDOWS) && AOKeyStore.WINDOWS.equals((Object)aOKeyStore)) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getWindowsMyCapiKeyStoreManager(bl));
        }
        if (Platform.getOS().equals((Object)Platform.OS.WINDOWS) && (AOKeyStore.WINADDRESSBOOK.equals((Object)aOKeyStore) || AOKeyStore.WINCA.equals((Object)aOKeyStore))) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getWindowsAddressBookKeyStoreManager(aOKeyStore, bl));
        }
        if (AOKeyStore.MOZ_UNI.equals((Object)aOKeyStore)) {
            return AOKeyStoreManagerFactory.getMozillaUnifiedKeyStoreManager(passwordCallback, bl, object);
        }
        if (Platform.getOS().equals((Object)Platform.OS.LINUX) && AOKeyStore.SHARED_NSS.equals((Object)aOKeyStore)) {
            return AOKeyStoreManagerFactory.getSharedNssKeyStoreManager(passwordCallback, bl, object);
        }
        if (Platform.getOS().equals((Object)Platform.OS.MACOSX) && AOKeyStore.APPLE.equals((Object)aOKeyStore)) {
            return AOKeyStoreManagerFactory.getMacOSXKeyStoreManager(aOKeyStore, string, bl, object);
        }
        if (AOKeyStore.DNIEJAVA.equals((Object)aOKeyStore)) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getDnieJavaKeyStoreManager(passwordCallback, bl, object));
        }
        if (AOKeyStore.CERES_430.equals((Object)aOKeyStore)) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getCeres430JavaKeyStoreManager(passwordCallback, bl, object));
        }
        if (AOKeyStore.CERES.equals((Object)aOKeyStore)) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getCeresJavaKeyStoreManager(passwordCallback, bl, object));
        }
        if (AOKeyStore.SMARTCAFE.equals((Object)aOKeyStore)) {
            return new AggregatedKeyStoreManager(AOKeyStoreManagerFactory.getSmartCafeJavaKeyStoreManager(passwordCallback, bl, object));
        }
        throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(aOKeyStore), "La plataforma de navegador '" + aOKeyStore.getName() + "' mas sistema operativo '" + (Object)((Object)Platform.getOS()) + "' no esta soportada");
    }

    private static AOKeyStoreManager addFileKeyStoreManager(AOKeyStoreManager aOKeyStoreManager, String[] stringArray, String string, String string2, PasswordCallback passwordCallback, boolean bl, Object object) throws AOKeystoreAlternativeException, IOException {
        String string3 = null;
        if (string2 != null && !string2.isEmpty() && new File(string2).exists()) {
            string3 = string2;
        }
        if (string3 == null && (string3 = AOUIFactory.getLoadFiles(KeyStoreMessages.getString("AOKeyStoreManagerFactory.4") + " " + aOKeyStoreManager.getType().getName(), null, null, stringArray, string, false, false, null, object)[0].getAbsolutePath()) == null) {
            throw new AOCancelledOperationException("No se ha seleccionado el almacen de certificados");
        }
        try (FileInputStream fileInputStream = new FileInputStream(string3);){
            aOKeyStoreManager.init(null, fileInputStream, passwordCallback, null, bl);
        }
        catch (AOException aOException) {
            throw new AOKeystoreAlternativeException(AOKeyStore.JAVA, "No se ha podido abrir el almacen de tipo " + aOKeyStoreManager.getType().getName() + " para el fichero " + string2, aOException);
        }
        return aOKeyStoreManager;
    }

    private static AOKeyStoreManager getPkcs12KeyStoreManager(String string, PasswordCallback passwordCallback, boolean bl, Object object) throws IOException, AOKeystoreAlternativeException {
        Pkcs12KeyStoreManager pkcs12KeyStoreManager = new Pkcs12KeyStoreManager();
        pkcs12KeyStoreManager.setKeyStoreFile(string);
        return AOKeyStoreManagerFactory.addFileKeyStoreManager(pkcs12KeyStoreManager, new String[]{"pfx", "p12"}, KeyStoreMessages.getString("AOKeyStoreManagerFactory.0"), string, passwordCallback, bl, object);
    }

    private static AOKeyStoreManager getJavaKeyStoreManager(String string, PasswordCallback passwordCallback, boolean bl, Object object) throws IOException, AOKeystoreAlternativeException {
        JavaKeyStoreManager javaKeyStoreManager = new JavaKeyStoreManager();
        javaKeyStoreManager.setKeyStoreFile(string);
        return AOKeyStoreManagerFactory.addFileKeyStoreManager(javaKeyStoreManager, new String[]{"jks"}, KeyStoreMessages.getString("AOKeyStoreManagerFactory.1"), string, passwordCallback, bl, object);
    }

    private static AOKeyStoreManager getSmartCafeJavaKeyStoreManager(PasswordCallback passwordCallback, boolean bl, Object object) throws AOKeystoreAlternativeException, IOException {
        AOKeyStoreManager aOKeyStoreManager = new AOKeyStoreManager();
        try {
            aOKeyStoreManager.init(AOKeyStore.SMARTCAFE, null, passwordCallback, new Object[]{object}, bl);
        }
        catch (AOKeyStoreManagerException aOKeyStoreManagerException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(AOKeyStore.PKCS12), "Error al inicializar el modulo G&D SmartCafe 100% Java: " + aOKeyStoreManagerException, aOKeyStoreManagerException);
        }
        aOKeyStoreManager.setPreferred(true);
        return aOKeyStoreManager;
    }

    private static AOKeyStoreManager getCeresJavaKeyStoreManager(PasswordCallback passwordCallback, boolean bl, Object object) throws AOKeystoreAlternativeException, IOException {
        AOKeyStoreManager aOKeyStoreManager = new AOKeyStoreManager();
        try {
            aOKeyStoreManager.init(AOKeyStore.CERES, null, passwordCallback, new Object[]{object}, bl);
        }
        catch (AOKeyStoreManagerException aOKeyStoreManagerException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(AOKeyStore.PKCS12), "Error al inicializar el modulo CERES 100% Java: " + aOKeyStoreManagerException, aOKeyStoreManagerException);
        }
        aOKeyStoreManager.setPreferred(true);
        return aOKeyStoreManager;
    }

    private static AOKeyStoreManager getCeres430JavaKeyStoreManager(PasswordCallback passwordCallback, boolean bl, Object object) throws AOKeystoreAlternativeException, IOException {
        AOKeyStoreManager aOKeyStoreManager = new AOKeyStoreManager();
        try {
            aOKeyStoreManager.init(AOKeyStore.CERES_430, null, passwordCallback, new Object[]{object}, bl);
        }
        catch (AOKeyStoreManagerException aOKeyStoreManagerException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(AOKeyStore.PKCS12), "Error al inicializar el modulo CERES 430 100% Java: " + aOKeyStoreManagerException, aOKeyStoreManagerException);
        }
        aOKeyStoreManager.setPreferred(true);
        return aOKeyStoreManager;
    }

    private static AOKeyStoreManager getDnieJavaKeyStoreManager(PasswordCallback passwordCallback, boolean bl, Object object) throws AOKeystoreAlternativeException, IOException {
        AOKeyStoreManager aOKeyStoreManager = new AOKeyStoreManager();
        try {
            aOKeyStoreManager.init(AOKeyStore.DNIEJAVA, null, passwordCallback, new Object[]{object}, bl);
        }
        catch (AOKeyStoreManagerException aOKeyStoreManagerException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(AOKeyStore.PKCS12), "Error al inicializar el modulo DNIe 100% Java: " + aOKeyStoreManagerException, aOKeyStoreManagerException);
        }
        aOKeyStoreManager.setPreferred(true);
        return aOKeyStoreManager;
    }

    private static AOKeyStoreManager getFileKeyStoreManager(AOKeyStore aOKeyStore, String string, PasswordCallback passwordCallback, boolean bl, Object object) throws IOException, AOKeystoreAlternativeException {
        Object object2;
        Object object3;
        AOKeyStoreManager aOKeyStoreManager = new AOKeyStoreManager();
        String string2 = null;
        if (string != null && !string.isEmpty() && new File(string).exists()) {
            string2 = string;
        } else {
            object3 = null;
            object2 = null;
            if (aOKeyStore == AOKeyStore.SINGLE) {
                object2 = new String[]{"cer", "p7b"};
                object3 = KeyStoreMessages.getString("AOKeyStoreManagerFactory.2");
            } else if (aOKeyStore == AOKeyStore.JCEKS || aOKeyStore == AOKeyStore.JAVACE) {
                object2 = new String[]{"jceks", "jks", "jce"};
                object3 = KeyStoreMessages.getString("AOKeyStoreManagerFactory.3");
            }
            string2 = AOUIFactory.getLoadFiles(KeyStoreMessages.getString("AOKeyStoreManagerFactory.4") + " " + aOKeyStore.getName(), null, null, (String[])object2, (String)object3, false, false, null, object)[0].getAbsolutePath();
            if (string2 == null) {
                throw new AOCancelledOperationException("No se ha seleccionado el almacen de certificados");
            }
        }
        try {
            object3 = new FileInputStream(string2);
            object2 = null;
            try {
                aOKeyStoreManager.init(aOKeyStore, (InputStream)object3, passwordCallback, null, bl);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object3 != null) {
                    if (object2 != null) {
                        try {
                            ((InputStream)object3).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object3).close();
                    }
                }
            }
        }
        catch (AOException aOException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(aOKeyStore), "No se ha podido abrir el almacen de tipo " + aOKeyStore.getName(), aOException);
        }
        return aOKeyStoreManager;
    }

    private static AOKeyStoreManager getPkcs11KeyStoreManager(String string, String string2, PasswordCallback passwordCallback, boolean bl, Object object) throws IOException, AOKeystoreAlternativeException {
        AOKeyStoreManager aOKeyStoreManager = new AOKeyStoreManager();
        String string3 = null;
        if (string != null && !string.isEmpty()) {
            string3 = string;
        }
        if (string3 != null && !new File(string3).isFile()) {
            throw new IOException("La biblioteca '" + string3 + "' no existe");
        }
        if (string3 == null) {
            String[] stringArray;
            String string4 = KeyStoreMessages.getString("AOKeyStoreManagerFactory.6");
            if (Platform.OS.WINDOWS.equals((Object)Platform.getOS())) {
                stringArray = new String[]{"dll"};
                string4 = string4 + " (*.dll)";
            } else if (Platform.OS.MACOSX.equals((Object)Platform.getOS())) {
                stringArray = new String[]{"so", "dylib"};
                string4 = string4 + " (*.dylib, *.so)";
            } else {
                stringArray = new String[]{"so"};
                string4 = string4 + " (*.so)";
            }
            string3 = AOUIFactory.getLoadFiles(KeyStoreMessages.getString("AOKeyStoreManagerFactory.7"), null, null, stringArray, string4, false, false, null, object)[0].getAbsolutePath();
        }
        if (string3 == null) {
            throw new AOCancelledOperationException("No se ha seleccionado el controlador PKCS#11");
        }
        try {
            aOKeyStoreManager.init(AOKeyStore.PKCS11, null, passwordCallback, new String[]{string3, string2}, bl);
        }
        catch (AOException aOException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(AOKeyStore.PKCS11), "Error al inicializar el modulo PKCS#11: " + aOException, aOException);
        }
        return aOKeyStoreManager;
    }

    private static AOKeyStoreManager getWindowsAddressBookKeyStoreManager(AOKeyStore aOKeyStore, boolean bl) throws IOException, AOKeystoreAlternativeException {
        AOKeyStoreManager aOKeyStoreManager = new AOKeyStoreManager();
        try {
            aOKeyStoreManager.init(aOKeyStore, null, NullPasswordCallback.getInstance(), null, bl);
        }
        catch (AOException aOException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(aOKeyStore), "Error al inicializar el almacen " + aOKeyStore.getName(), aOException);
        }
        return aOKeyStoreManager;
    }

    private static AOKeyStoreManager getWindowsMyCapiKeyStoreManager(boolean bl) throws AOKeystoreAlternativeException, IOException {
        CAPIUnifiedKeyStoreManager cAPIUnifiedKeyStoreManager = new CAPIUnifiedKeyStoreManager();
        try {
            ((AOKeyStoreManager)cAPIUnifiedKeyStoreManager).init(AOKeyStore.WINDOWS, null, null, null, bl);
        }
        catch (AOKeyStoreManagerException aOKeyStoreManagerException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(AOKeyStore.WINDOWS), "Error al obtener almacen WINDOWS: " + aOKeyStoreManagerException, aOKeyStoreManagerException);
        }
        return cAPIUnifiedKeyStoreManager;
    }

    private static AggregatedKeyStoreManager getNssKeyStoreManager(String string, PasswordCallback passwordCallback, boolean bl, Object object) throws AOKeystoreAlternativeException, IOException {
        AggregatedKeyStoreManager aggregatedKeyStoreManager;
        try {
            aggregatedKeyStoreManager = (AggregatedKeyStoreManager)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(AOKeyStore.MOZ_UNI), "Error al obtener dinamicamente el almacen NSS: " + exception, exception);
        }
        try {
            aggregatedKeyStoreManager.init(AOKeyStore.SHARED_NSS, null, passwordCallback, new Object[]{object}, bl);
        }
        catch (AOException aOException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(AOKeyStore.MOZ_UNI), "Error al inicializar el almacen NSS: " + aOException, aOException);
        }
        return aggregatedKeyStoreManager;
    }

    private static AggregatedKeyStoreManager getSharedNssKeyStoreManager(PasswordCallback passwordCallback, boolean bl, Object object) throws AOKeystoreAlternativeException, IOException {
        return AOKeyStoreManagerFactory.getNssKeyStoreManager("es.gob.afirma.keystores.mozilla.shared.SharedNssKeyStoreManager", passwordCallback, bl, object);
    }

    private static AggregatedKeyStoreManager getMozillaUnifiedKeyStoreManager(PasswordCallback passwordCallback, boolean bl, Object object) throws AOKeystoreAlternativeException, IOException {
        AggregatedKeyStoreManager aggregatedKeyStoreManager = mozillaKeyStoreManager;
        if (aggregatedKeyStoreManager == null && !AOKeyStoreManagerFactory.containsDnieJavaKeyStoreManager(aggregatedKeyStoreManager = AOKeyStoreManagerFactory.getNssKeyStoreManager("es.gob.afirma.keystores.mozilla.MozillaUnifiedKeyStoreManager", passwordCallback, bl, object))) {
            mozillaKeyStoreManager = aggregatedKeyStoreManager;
        }
        return aggregatedKeyStoreManager;
    }

    private static boolean containsDnieJavaKeyStoreManager(AggregatedKeyStoreManager aggregatedKeyStoreManager) {
        for (AOKeyStoreManager aOKeyStoreManager : aggregatedKeyStoreManager.getKeyStoreManagers()) {
            if (aOKeyStoreManager.getType() != AOKeyStore.DNIEJAVA && (!(aOKeyStoreManager instanceof AggregatedKeyStoreManager) || !AOKeyStoreManagerFactory.containsDnieJavaKeyStoreManager((AggregatedKeyStoreManager)aOKeyStoreManager))) continue;
            return true;
        }
        return false;
    }

    private static AggregatedKeyStoreManager getMacOSXKeyStoreManager(AOKeyStore aOKeyStore, String string, boolean bl, Object object) throws IOException, AOKeystoreAlternativeException {
        Object object2;
        AppleKeyStoreManager appleKeyStoreManager = new AppleKeyStoreManager();
        try {
            object2 = string == null || string.isEmpty() ? null : new FileInputStream(string);
            Throwable throwable = null;
            try {
                ((AOKeyStoreManager)appleKeyStoreManager).init(aOKeyStore, (InputStream)object2, NullPasswordCallback.getInstance(), null, bl);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object2).close();
                    }
                }
            }
        }
        catch (AOException aOException) {
            throw new AOKeystoreAlternativeException(AOKeyStoreManagerFactory.getAlternateKeyStoreType(aOKeyStore), "Error al inicializar el Llavero de Mac OS X", aOException);
        }
        object2 = new AggregatedKeyStoreManager(appleKeyStoreManager);
        try {
            KeyStoreUtilities.addPreferredKeyStoreManagers((AggregatedKeyStoreManager)object2, object);
        }
        catch (AOCancelledOperationException aOCancelledOperationException) {
            LOGGER.info("Se cancelo el uso del driver Java: " + aOCancelledOperationException);
        }
        return object2;
    }

    private static AOKeyStore getAlternateKeyStoreType(AOKeyStore aOKeyStore) {
        if (AOKeyStore.PKCS12.equals((Object)aOKeyStore)) {
            return null;
        }
        if (Platform.OS.WINDOWS.equals((Object)Platform.getOS()) && !AOKeyStore.WINDOWS.equals((Object)aOKeyStore)) {
            return AOKeyStore.WINDOWS;
        }
        if (Platform.OS.MACOSX.equals((Object)Platform.getOS()) && !AOKeyStore.APPLE.equals((Object)aOKeyStore)) {
            return AOKeyStore.APPLE;
        }
        return AOKeyStore.PKCS12;
    }
}

