/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.keystores.KeyStoreManager;
import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.keystores.AOKeyStore;
import es.gob.afirma.keystores.AOKeyStoreManagerException;
import es.gob.afirma.keystores.AOKeyStoreManagerHelperCapiAddressBook;
import es.gob.afirma.keystores.AOKeyStoreManagerHelperFullJava;
import es.gob.afirma.keystores.AOKeyStoreManagerHelperJava;
import es.gob.afirma.keystores.AOKeyStoreManagerHelperPkcs11;
import es.gob.afirma.keystores.AOKeyStoreManagerHelperSingle;
import es.gob.afirma.keystores.SmartCardLockedException;
import es.gob.jmulticard.CancelledOperationException;
import es.gob.jmulticard.card.AuthenticationModeLockedException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

public class AOKeyStoreManager
implements KeyStoreManager {
    private Object parentComponent = null;
    protected static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private final Set<String> deactivatedCertificatesThumbprints = new HashSet<String>();
    private String[] cachedAliases = null;
    private boolean preferred = false;
    private AOKeyStore ksType;
    private KeyStore ks;
    private InputStream storeIs;
    private PasswordCallback storePasswordCallBack;
    private PasswordCallback entryPasswordCallBack = null;
    private Object[] storeParams;

    protected Object getParentComponent() {
        return this.parentComponent;
    }

    @Override
    public void setParentComponent(Object object) {
        this.parentComponent = object;
    }

    protected void resetCachedAliases() {
        this.cachedAliases = null;
    }

    protected String[] getCachedAliases() {
        return this.cachedAliases;
    }

    protected void setCachedAliases(String[] stringArray) {
        this.cachedAliases = (String[])stringArray.clone();
    }

    protected boolean isPreferred() {
        return this.preferred;
    }

    void setPreferred(boolean bl) {
        this.preferred = bl;
    }

    protected void setKeyStore(KeyStore keyStore) {
        this.ks = keyStore;
    }

    public KeyStore getKeyStore() {
        return this.ks;
    }

    @Override
    public void refresh() throws IOException {
        this.resetCachedAliases();
        try {
            this.init(this.ksType, this.storeIs, this.storePasswordCallBack, this.storeParams, true);
        }
        catch (AOKeyStoreManagerException aOKeyStoreManagerException) {
            this.ks = null;
            throw new IOException("Error al refrescar el almacen, se ocultaran sus entradas " + aOKeyStoreManagerException, aOKeyStoreManagerException);
        }
    }

    protected boolean lacksKeyStores() {
        return this.ks == null;
    }

    protected final void setKeyStoreType(AOKeyStore aOKeyStore) {
        this.ksType = aOKeyStore;
    }

    public AOKeyStore getType() {
        return this.ksType;
    }

    protected AOKeyStore getType(String string) {
        return this.getType();
    }

    @Override
    public void setEntryPasswordCallBack(PasswordCallback passwordCallback) {
        this.entryPasswordCallBack = passwordCallback;
    }

    protected PasswordCallback getEntryPasswordCallBack() {
        return this.entryPasswordCallBack;
    }

    public void init(AOKeyStore aOKeyStore, InputStream inputStream, PasswordCallback passwordCallback, Object[] objectArray, boolean bl) throws AOKeyStoreManagerException, IOException {
        if (aOKeyStore == null) {
            throw new IllegalArgumentException("Se ha solicitado inicializar un AOKeyStore nulo");
        }
        LOGGER.info("Inicializamos el almacen de tipo: " + (Object)((Object)aOKeyStore));
        this.resetCachedAliases();
        this.ksType = aOKeyStore;
        this.storeIs = inputStream;
        this.storePasswordCallBack = passwordCallback;
        if (objectArray == null) {
            this.storeParams = null;
        } else {
            this.storeParams = new Object[objectArray.length];
            System.arraycopy(objectArray, 0, this.storeParams, 0, objectArray.length);
        }
        switch (this.ksType) {
            case SINGLE: {
                this.ks = AOKeyStoreManagerHelperSingle.initSingle(inputStream, passwordCallback);
                break;
            }
            case SMARTCAFE: {
                this.setParentComponent(objectArray != null && objectArray.length > 0 ? objectArray[0] : null);
                this.ks = AOKeyStoreManagerHelperFullJava.initSmartCafeJava(this.getParentComponent());
                break;
            }
            case CERES: {
                this.setParentComponent(objectArray != null && objectArray.length > 0 ? objectArray[0] : null);
                this.ks = AOKeyStoreManagerHelperFullJava.initCeresJava(this.getParentComponent());
                break;
            }
            case CERES_430: {
                this.setParentComponent(objectArray != null && objectArray.length > 0 ? objectArray[0] : null);
                this.ks = AOKeyStoreManagerHelperFullJava.initCeres430Java(this.getParentComponent());
                break;
            }
            case DNIEJAVA: {
                this.setParentComponent(objectArray != null && objectArray.length > 0 ? objectArray[0] : null);
                this.ks = AOKeyStoreManagerHelperFullJava.initDnieJava(this.getParentComponent());
                break;
            }
            case JAVACE: 
            case JCEKS: {
                this.ks = AOKeyStoreManagerHelperJava.initJava(inputStream, passwordCallback, this.ksType);
                break;
            }
            case WINCA: 
            case WINADDRESSBOOK: {
                this.ks = AOKeyStoreManagerHelperCapiAddressBook.initCAPIAddressBook(this.ksType);
                break;
            }
            case PKCS11: {
                Object[] objectArray2 = null;
                if (objectArray != null) {
                    objectArray2 = new Object[objectArray.length];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                }
                this.ks = AOKeyStoreManagerHelperPkcs11.initPKCS11(passwordCallback, objectArray2, bl, this.getParentComponent());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Tipo de almacen no soportado: " + (Object)((Object)this.ksType));
            }
        }
    }

    @Override
    public KeyStore.PrivateKeyEntry getKeyEntry(String string) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        PasswordCallback passwordCallback;
        if (this.ks == null) {
            throw new IllegalStateException("Se han pedido claves a un almacen no inicializado");
        }
        if (string == null) {
            throw new IllegalArgumentException("El alias no puede ser nulo");
        }
        KeyStore.PasswordProtection passwordProtection = this.entryPasswordCallBack != null ? new KeyStore.PasswordProtection(this.entryPasswordCallBack.getPassword()) : ((passwordCallback = this.getType(string).getCertificatePasswordCallback(this.getParentComponent())) != null ? new KeyStore.PasswordProtection(passwordCallback.getPassword()) : null);
        return (KeyStore.PrivateKeyEntry)this.ks.getEntry(string, passwordProtection);
    }

    @Override
    public X509Certificate getCertificate(String string) {
        if (string == null) {
            LOGGER.warning("El alias del certificado es nulo, se devolvera null");
            return null;
        }
        if (this.ks == null) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + string + "' porque el KeyStore no estaba inicializado, se devolvera null");
            return null;
        }
        try {
            return (X509Certificate)this.ks.getCertificate(string);
        }
        catch (AuthenticationModeLockedException authenticationModeLockedException) {
            throw new SmartCardLockedException("Tarjeta inteligente bloqueada: " + authenticationModeLockedException, authenticationModeLockedException);
        }
        catch (CancelledOperationException cancelledOperationException) {
            throw new AOCancelledOperationException("Se cancelo uso de la tarjeta a traves del driver Java: " + cancelledOperationException, cancelledOperationException);
        }
        catch (Exception exception) {
            LOGGER.severe("Error intentando recuperar el certificado con el alias '" + string + "', se devolvera null: " + exception);
            return null;
        }
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        if (string == null) {
            LOGGER.warning("El alias del certificado es nulo, se devolvera una cadena vacia");
            return new X509Certificate[0];
        }
        if (this.ks == null) {
            LOGGER.warning("No se ha podido recuperar el certificado con alias '" + string + "' porque el KeyStore no estaba inicializado, se devolvera una cadena vacia");
            return new X509Certificate[0];
        }
        try {
            Certificate[] certificateArray = this.ks.getCertificateChain(string);
            if (certificateArray == null) {
                return new X509Certificate[0];
            }
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            for (Certificate certificate : certificateArray) {
                if (!(certificate instanceof X509Certificate)) continue;
                arrayList.add((X509Certificate)certificate);
            }
            return arrayList.toArray(new X509Certificate[0]);
        }
        catch (Exception exception) {
            LOGGER.severe("Error intentando recuperar la cadena del certificado con alias '" + string + "', se continuara con el siguiente almacen: " + exception);
            LOGGER.warning("El almacen no contiene ningun certificado con el alias '" + string + "', se devolvera una cadena vacia");
            return new X509Certificate[0];
        }
    }

    @Override
    public String[] getAliases() {
        if (this.ks == null) {
            throw new IllegalStateException("Se han pedido alias a un almacen no inicializado");
        }
        if (this.cachedAliases != null) {
            return this.cachedAliases;
        }
        try {
            this.cachedAliases = this.cleanDeactivatedAliases(Collections.list(this.ks.aliases()).toArray(new String[0]));
        }
        catch (KeyStoreException keyStoreException) {
            LOGGER.severe("Error intentando recuperar los alias, se devolvera una lista vacia: " + keyStoreException);
            return new String[0];
        }
        return this.cachedAliases;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Gestor de almacenes de claves ");
        stringBuilder.append((Object)this.ksType);
        if (this.ksType != null && this.ksType.getName() != null) {
            stringBuilder.append(" con nombre ");
            stringBuilder.append(this.ksType.getName());
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isKeyEntry(String string) throws KeyStoreException {
        return this.getKeyStore().isKeyEntry(string);
    }

    protected String[] cleanDeactivatedAliases(String[] stringArray) {
        MessageDigest messageDigest;
        if (this.deactivatedCertificatesThumbprints.isEmpty()) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.warning("No se ha podido instanciar el generador de huellas digitales SHA1, pueden aparecer duplicados en la lista de certificados: " + noSuchAlgorithmException);
            return stringArray;
        }
        for (String string : stringArray) {
            String string2;
            try {
                string2 = AOUtil.hexify(messageDigest.digest(this.getCertificate(string).getEncoded()), false);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                LOGGER.severe("No se ha obtener la huela del certificado '" + string + "', pueden aparecer duplicados en la lista de certificados: " + certificateEncodingException);
                continue;
            }
            if (this.deactivatedCertificatesThumbprints.contains(string2)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public void deactivateEntry(String string) {
        if (string != null) {
            this.deactivatedCertificatesThumbprints.add(string);
        }
        this.resetCachedAliases();
    }
}

