/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.keystores;

import es.gob.afirma.core.AOCancelledOperationException;
import es.gob.afirma.core.AOException;
import es.gob.afirma.core.keystores.KeyStoreManager;
import es.gob.afirma.core.keystores.NameCertificateBean;
import es.gob.afirma.core.ui.AOUIFactory;
import es.gob.afirma.core.ui.KeyStoreDialogManager;
import es.gob.afirma.keystores.AOCertificatesNotFoundException;
import es.gob.afirma.keystores.AOKeyStoreManager;
import es.gob.afirma.keystores.AggregatedKeyStoreManager;
import es.gob.afirma.keystores.KeyStoreMessages;
import es.gob.afirma.keystores.KeyStoreUtilities;
import es.gob.afirma.keystores.filters.CertificateFilter;
import java.io.IOException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public final class AOKeyStoreDialog
implements KeyStoreDialogManager {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private KeyStoreManager ksm;
    private final Object parentComponent;
    private final boolean checkPrivateKeys;
    private final boolean checkValidity;
    private final boolean showExpiredCertificates;
    private final List<? extends CertificateFilter> certFilters;
    private final boolean mandatoryCertificate;
    private String selectedAlias = null;
    private boolean allowExternalStores = true;

    public AOKeyStoreDialog(AOKeyStoreManager aOKeyStoreManager, Object object, boolean bl, boolean bl2, boolean bl3) {
        this(aOKeyStoreManager, object, bl, bl2, bl3, null, false);
    }

    public AOKeyStoreDialog(AOKeyStoreManager aOKeyStoreManager, Object object, boolean bl, boolean bl2, boolean bl3, List<? extends CertificateFilter> list, boolean bl4) {
        if (aOKeyStoreManager == null) {
            throw new IllegalArgumentException("El almacen de claves no puede ser nulo");
        }
        this.ksm = aOKeyStoreManager;
        this.parentComponent = object;
        this.checkPrivateKeys = bl;
        this.checkValidity = bl3;
        this.showExpiredCertificates = bl2;
        this.certFilters = list;
        this.mandatoryCertificate = bl4;
    }

    @Override
    public NameCertificateBean[] getNameCertificates() {
        Map<String, String> map = KeyStoreUtilities.getAliasesByFriendlyName(this.ksm.getAliases(), this.ksm, this.checkPrivateKeys, this.showExpiredCertificates, this.certFilters);
        int n = 0;
        NameCertificateBean[] nameCertificateBeanArray = new NameCertificateBean[map.size()];
        for (String string : map.keySet().toArray(new String[map.size()])) {
            X509Certificate[] x509CertificateArray = this.ksm.getCertificateChain(string);
            if (x509CertificateArray != null) {
                nameCertificateBeanArray[n++] = new NameCertificateBean(string, map.get(string), x509CertificateArray);
                continue;
            }
            LOGGER.warning("Se ha encontrado un certificado nulo en el almacen");
        }
        return nameCertificateBeanArray;
    }

    @Override
    public void setKeyStoreManager(KeyStoreManager keyStoreManager) {
        if (this.ksm instanceof AggregatedKeyStoreManager && keyStoreManager instanceof AOKeyStoreManager) {
            ((AggregatedKeyStoreManager)this.ksm).removeAll();
            ((AggregatedKeyStoreManager)this.ksm).addKeyStoreManager((AOKeyStoreManager)keyStoreManager);
        }
        this.ksm = keyStoreManager;
    }

    @Override
    public Object getKeyEntry(String string) throws AOException {
        X509Certificate[] x509CertificateArray = null;
        if (this.checkPrivateKeys) {
            try {
                x509CertificateArray = this.ksm.getKeyEntry(string);
            }
            catch (Exception exception) {
                LOGGER.severe("No se ha podido extraer la clave del almacen: " + exception);
                throw new AOException("No se ha podido extraer la clave del almacen", exception);
            }
        }
        this.selectedAlias = string;
        if (this.checkValidity && this.ksm != null) {
            String string2 = null;
            X509Certificate x509Certificate = this.ksm.getCertificate(this.selectedAlias);
            try {
                x509Certificate.checkValidity();
            }
            catch (CertificateExpiredException certificateExpiredException) {
                string2 = KeyStoreMessages.getString("AOKeyStoreDialog.2");
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                string2 = KeyStoreMessages.getString("AOKeyStoreDialog.3");
            }
            catch (Exception exception) {
                string2 = KeyStoreMessages.getString("AOKeyStoreDialog.4");
            }
            boolean bl = false;
            if (string2 != null) {
                LOGGER.warning("Error durante la validacion: " + string2);
                if (AOUIFactory.showConfirmDialog(this.parentComponent, string2, KeyStoreMessages.getString("AOKeyStoreDialog.5"), AOUIFactory.YES_NO_OPTION, AOUIFactory.WARNING_MESSAGE) != AOUIFactory.YES_OPTION) {
                    bl = true;
                }
            }
            if (bl) {
                throw new AOCancelledOperationException("Se ha reusado un certificado probablemente no valido");
            }
        }
        return this.checkPrivateKeys ? x509CertificateArray : this.ksm.getCertificateChain(string);
    }

    @Override
    public String show() throws AOCertificatesNotFoundException {
        NameCertificateBean[] nameCertificateBeanArray = this.getNameCertificates();
        if (this.mandatoryCertificate && nameCertificateBeanArray != null && nameCertificateBeanArray.length == 1) {
            this.selectedAlias = nameCertificateBeanArray[0].getAlias();
            return this.selectedAlias;
        }
        try {
            this.selectedAlias = AOUIFactory.showCertificateSelectionDialog(this.parentComponent, this);
        }
        catch (IllegalStateException illegalStateException) {
            throw new AOCertificatesNotFoundException("No se han encontrado certificados validos en el almacen", illegalStateException);
        }
        if (this.selectedAlias == null) {
            throw new AOCancelledOperationException("No se ha seleccionado certificado");
        }
        return this.selectedAlias;
    }

    @Override
    public String getSelectedAlias() {
        return this.selectedAlias;
    }

    @Override
    public void refresh() throws IOException {
        this.ksm.refresh();
    }

    @Override
    public void allowOpenExternalStores(boolean bl) {
        this.allowExternalStores = bl;
    }

    @Override
    public boolean isExternalStoresOpeningAllowed() {
        return this.allowExternalStores;
    }
}

