/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers.asic;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.MimeHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ASiCUtil {
    private static final String ASIC_S_MIMETYPE = "application/vnd.etsi.asic-s+zip";
    private static final String DEFAULT_DATAOBJECT_EXTENSION = "bin";
    public static final String ENTRY_NAME_BINARY_SIGNATURE = "META-INF/signature.p7s";
    public static final String ENTRY_NAME_XML_SIGNATURE = "META-INF/signatures.xml";
    private static final String ENTRY_NAME_MIMETYPE = "mimetype";
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");

    private ASiCUtil() {
    }

    public static String getASiCSDefaultDataFilename(byte[] byArray) {
        String string;
        try {
            string = new MimeHelper(byArray).getExtension();
        }
        catch (IOException iOException) {
            LOGGER.warning("No se pudieron cargar los datos para su analisis: " + iOException);
            string = null;
        }
        return "dataobject." + (string != null && !string.isEmpty() ? string : DEFAULT_DATAOBJECT_EXTENSION);
    }

    public static byte[] createSContainer(byte[] byArray, byte[] byArray2, String string, String string2) throws IOException {
        if (byArray == null || byArray.length < 1) {
            throw new IllegalArgumentException("La firma no puede ser nula ni vacia");
        }
        if (byArray2 == null || byArray2.length < 1) {
            throw new IllegalArgumentException("Los datos no pueden ser nulos ni vacios");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);){
            zipOutputStream.setComment("mimetype=application/vnd.etsi.asic-s+zip");
            ZipEntry zipEntry = new ZipEntry(ENTRY_NAME_MIMETYPE);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(ASIC_S_MIMETYPE.getBytes());
            String string3 = string2 != null ? string2 : ASiCUtil.getASiCSDefaultDataFilename(byArray2);
            zipEntry = new ZipEntry(string3);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArray2);
            zipEntry = new ZipEntry(string != null ? string : ENTRY_NAME_BINARY_SIGNATURE);
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArray);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] getASiCSBinarySignature(byte[] byArray) throws IOException {
        return ASiCUtil.getASiCSSignature(byArray, ENTRY_NAME_BINARY_SIGNATURE);
    }

    public static byte[] getASiCSXMLSignature(byte[] byArray) throws IOException {
        return ASiCUtil.getASiCSSignature(byArray, ENTRY_NAME_XML_SIGNATURE);
    }

    private static byte[] getASiCSSignature(byte[] byArray, String string) throws IOException {
        if (byArray == null || byArray.length < 1) {
            throw new IllegalArgumentException("La firma ASiC proporcionada no puede ser nula ni vacia");
        }
        if (string == null) {
            throw new IllegalArgumentException("La firma entrada de firma del ASiC no puede ser nula");
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                byte[] byArray2 = AOUtil.getDataFromInputStream(zipInputStream);
                return byArray2;
            }
        }
        throw new IOException("Los datos proporcionados no son una firma ASiC-S conteniendo la entrada " + string);
    }

    public static byte[] getASiCSData(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length < 1) {
            throw new IllegalArgumentException("La firma ASiC proporcionada no puede ser nula ni vacia");
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (ENTRY_NAME_BINARY_SIGNATURE.equals(zipEntry.getName()) || ENTRY_NAME_XML_SIGNATURE.equals(zipEntry.getName()) || ENTRY_NAME_MIMETYPE.equals(zipEntry.getName())) continue;
                byte[] byArray2 = AOUtil.getDataFromInputStream(zipInputStream);
                return byArray2;
            }
        }
        throw new IOException("Los datos proporcionados no son una firma ASiC-S");
    }

    public static String getASiCSDataFilename(byte[] byArray) throws IOException {
        ZipEntry zipEntry;
        if (byArray == null || byArray.length < 1) {
            throw new IllegalArgumentException("La firma ASiC proporcionada no puede ser nula ni vacia");
        }
        ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(byArray));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (ENTRY_NAME_BINARY_SIGNATURE.equals(string) || ENTRY_NAME_XML_SIGNATURE.equals(string) || ENTRY_NAME_MIMETYPE.equals(string)) continue;
            return string;
        }
        throw new IOException("Los datos proporcionados no son una firma ASiC-S");
    }
}

