/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.misc.AOUtil;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Date;

public final class AOSimpleSignInfo {
    private X509Certificate[] certs = null;
    private String signAlgorithm = null;
    private String signFormat = null;
    private Date signingTime = null;
    private Date[] timestampingTime = null;
    private byte[] pkcs1 = null;

    public AOSimpleSignInfo(X509Certificate[] x509CertificateArray, Date date) {
        if (x509CertificateArray == null || x509CertificateArray.length == 0 || x509CertificateArray[0] == null) {
            throw new IllegalArgumentException("No se ha introducido la cadena de certificacion");
        }
        this.certs = (X509Certificate[])x509CertificateArray.clone();
        this.signingTime = date;
    }

    public String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public void setSignAlgorithm(String string) {
        this.signAlgorithm = string;
    }

    public String getSignFormat() {
        return this.signFormat;
    }

    public void setSignFormat(String string) {
        this.signFormat = string;
    }

    public Date[] getTimestampingTime() {
        return this.timestampingTime == null ? null : (Date[])this.timestampingTime.clone();
    }

    public void setTimestampingTime(Date[] dateArray) {
        this.timestampingTime = dateArray == null ? null : (Date[])dateArray.clone();
    }

    public X509Certificate[] getCerts() {
        return this.certs == null ? null : (X509Certificate[])this.certs.clone();
    }

    public Date getSigningTime() {
        return this.signingTime;
    }

    public boolean isTimeStamped() {
        return this.timestampingTime != null && this.timestampingTime.length > 0 && this.timestampingTime[0] != null;
    }

    public byte[] getPkcs1() {
        return this.pkcs1 == null ? null : (byte[])this.pkcs1.clone();
    }

    public void setPkcs1(byte[] byArray) {
        this.pkcs1 = byArray == null ? null : (byte[])byArray.clone();
    }

    public String toString() {
        String string = AOUtil.getCN(this.certs[0]);
        if (this.timestampingTime != null && this.timestampingTime.length > 0 && this.timestampingTime[0] != null) {
            string = string + " (TimeStamp: " + DateFormat.getDateTimeInstance(2, 3).format(this.signingTime) + ")";
        } else if (this.signingTime != null) {
            string = string + " (" + DateFormat.getDateTimeInstance(2, 3).format(this.signingTime) + ")";
        }
        return string;
    }
}

