/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.signers;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSignInfo;
import es.gob.afirma.core.signers.AOSigner;
import es.gob.afirma.core.signers.CounterSignTarget;
import es.gob.afirma.core.util.tree.AOTreeModel;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;

public final class AOPkcs1Signer
implements AOSigner {
    private static final String PKCS1_FILE_SUFFIX = ".p1";

    @Override
    public byte[] sign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) throws AOException {
        Signature signature;
        try {
            if ("com.aet.android.providerPKCS15.SEPrivateKey".equals(privateKey.getClass().getName())) {
                signature = Signature.getInstance(string, "AETProvider");
            } else if ("es.gob.jmulticard.jse.provider.DniePrivateKey".equals(privateKey.getClass().getName())) {
                Logger.getLogger("es.gob.afirma").info("Detectada clave privada DNIe 100% Java");
                signature = Signature.getInstance(string, "DNIeJCAProvider");
            } else if ("es.gob.jmulticard.jse.provider.ceres.CeresPrivateKey".equals(privateKey.getClass().getName())) {
                Logger.getLogger("es.gob.afirma").info("Detectada clave privada CERES 100% Java");
                signature = Signature.getInstance(string, "CeresJCAProvider");
            } else {
                signature = Signature.getInstance(string);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOException("No se soporta el algoritmo de firma (" + string + "): " + noSuchAlgorithmException, noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new AOException("No hay un proveedor para el algoritmo '" + string + "' con el tipo de clave '" + privateKey.getAlgorithm() + "': " + noSuchProviderException, noSuchProviderException);
        }
        try {
            signature.initSign(privateKey);
        }
        catch (Exception exception) {
            throw new AOException("Error al inicializar la firma con la clave privada: " + exception, exception);
        }
        try {
            signature.update(byArray);
        }
        catch (Exception exception) {
            throw new AOException("Error al configurar los datos a firmar: " + exception, exception);
        }
        try {
            return signature.sign();
        }
        catch (Exception exception) {
            throw new AOException("Error durante el proceso de firma PKCS#1: " + exception, exception);
        }
    }

    @Override
    public byte[] cosign(byte[] byArray, byte[] byArray2, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se pueden hacer cofirmas en PKCS#1");
    }

    @Override
    public byte[] cosign(byte[] byArray, String string, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se pueden hacer cofirmas en PKCS#1");
    }

    @Override
    public byte[] countersign(byte[] byArray, String string, CounterSignTarget counterSignTarget, Object[] objectArray, PrivateKey privateKey, Certificate[] certificateArray, Properties properties) {
        throw new UnsupportedOperationException("No se pueden hacer contrafirmas en PKCS#1");
    }

    @Override
    public AOTreeModel getSignersStructure(byte[] byArray, boolean bl) {
        throw new UnsupportedOperationException("No se puede obtener la estructura de firmantes en PKCS#1");
    }

    @Override
    public boolean isSign(byte[] byArray) {
        return false;
    }

    @Override
    public boolean isValidDataFile(byte[] byArray) {
        return byArray != null && byArray.length > 0;
    }

    @Override
    public String getSignedName(String string, String string2) {
        String string3;
        String string4 = string3 = string2 != null ? string2 : "";
        if (string == null) {
            return "signature.p1";
        }
        if (string.toLowerCase(Locale.US).endsWith(PKCS1_FILE_SUFFIX)) {
            return string.substring(0, string.length() - PKCS1_FILE_SUFFIX.length()) + string3 + PKCS1_FILE_SUFFIX;
        }
        return string + string3 + PKCS1_FILE_SUFFIX;
    }

    @Override
    public byte[] getData(byte[] byArray) {
        throw new UnsupportedOperationException("No se pueden obtener los datos firmados en PKCS#1");
    }

    @Override
    public AOSignInfo getSignInfo(byte[] byArray) {
        throw new UnsupportedOperationException("No se puede obtener informacion de las firmas PKCS#1");
    }
}

