/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.misc.http;

import es.gob.afirma.core.misc.AOUtil;
import es.gob.afirma.core.misc.Base64;
import es.gob.afirma.core.misc.Platform;
import es.gob.afirma.core.misc.http.HttpError;
import es.gob.afirma.core.misc.http.URLName;
import es.gob.afirma.core.misc.http.UrlHttpManager;
import es.gob.afirma.core.misc.http.UrlHttpMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.PasswordCallback;

public class UrlHttpManagerImpl
implements UrlHttpManager {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    public static final String JAVA_PARAM_DISABLE_SSL_CHECKS = "disableSslChecks";
    public static final int DEFAULT_TIMEOUT = -1;
    private static final String HTTPS = "https";
    private static final String URN_SEPARATOR = ":";
    private static final String PROT_SEPARATOR = "://";
    private static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER = HttpsURLConnection.getDefaultHostnameVerifier();
    private static final SSLSocketFactory DEFAULT_SSL_SOCKET_FACTORY = HttpsURLConnection.getDefaultSSLSocketFactory();
    private static final String KEYSTORE = "javax.net.ssl.keyStore";
    private static final String KEYSTORE_PASS = "javax.net.ssl.keyStorePassword";
    private static final String KEYSTORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String KEYSTORE_DEFAULT_TYPE = "JKS";
    private static final String KEYMANAGER_INSTANCE = "SunX509";
    private static final String SSL_CONTEXT = "SSL";
    private static KeyStore sslKeyStore = null;
    private static PasswordCallback sslKeyStorePasswordCallback = null;
    private static final TrustManager[] DUMMY_TRUST_MANAGER;

    protected UrlHttpManagerImpl() {
    }

    public static void setSslKeyStore(KeyStore keyStore) {
        sslKeyStore = keyStore;
    }

    public static void setSslKeyStorePasswordCallback(PasswordCallback passwordCallback) {
        sslKeyStorePasswordCallback = passwordCallback;
    }

    @Override
    public byte[] readUrl(String string, UrlHttpMethod urlHttpMethod) throws IOException {
        return this.readUrl(string, -1, null, null, urlHttpMethod);
    }

    private static boolean isLocal(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("La URL no puede ser nula");
        }
        try {
            return InetAddress.getByName(uRL.getHost()).isLoopbackAddress();
        }
        catch (Exception exception) {
            LOGGER.warning("Error comprobando si una URL es el bucle local: " + exception);
            return false;
        }
    }

    @Override
    public byte[] readUrl(String string, int n, String string2, String string3, UrlHttpMethod urlHttpMethod) throws IOException {
        Properties properties = new Properties();
        if (string2 != null) {
            properties.setProperty("Content-Type", string2);
        }
        if (string3 != null) {
            properties.setProperty("Accept", string3);
        }
        return this.readUrl(string, n, urlHttpMethod, properties);
    }

    @Override
    public byte[] readUrl(String string, int n, UrlHttpMethod urlHttpMethod, Properties properties) throws IOException {
        byte[] byArray;
        Object object2;
        String string2;
        String string3;
        String string4;
        if (string == null) {
            throw new IllegalArgumentException("La URL a leer no puede ser nula");
        }
        URLName uRLName = new URLName(string);
        if (uRLName.getUsername() != null || uRLName.getPassword() != null) {
            string4 = uRLName.getUsername() != null && uRLName.getPassword() != null ? uRLName.getUsername() + URN_SEPARATOR + uRLName.getPassword() : (uRLName.getUsername() != null ? uRLName.getUsername() : uRLName.getPassword());
            string3 = Base64.encode(string4.getBytes());
            string2 = uRLName.getProtocol() + PROT_SEPARATOR + uRLName.getHost() + (uRLName.getPort() != -1 ? URN_SEPARATOR + Integer.toString(uRLName.getPort()) : "") + "/" + (uRLName.getFile() != null ? uRLName.getFile() : "");
        } else {
            string2 = string;
            string3 = null;
        }
        string4 = null;
        String string5 = null;
        if (UrlHttpMethod.POST.equals((Object)urlHttpMethod) || UrlHttpMethod.PUT.equals((Object)urlHttpMethod)) {
            object2 = new StringTokenizer(string2, "?");
            string5 = ((StringTokenizer)object2).nextToken();
            if (string2.contains("?")) {
                string4 = ((StringTokenizer)object2).nextToken();
            }
        }
        object2 = new URL(string5 != null ? string5 : string2);
        boolean bl = Boolean.parseBoolean(System.getProperty(JAVA_PARAM_DISABLE_SSL_CHECKS, "true"));
        if (bl && ((URL)object2).getProtocol().equals(HTTPS)) {
            try {
                UrlHttpManagerImpl.disableSslChecks();
            }
            catch (Exception exception) {
                LOGGER.warning("No se ha podido ajustar la confianza SSL, es posible que no se pueda completar la conexion: " + exception);
            }
        }
        HttpURLConnection httpURLConnection = Platform.OS.ANDROID.equals((Object)Platform.getOS()) || UrlHttpManagerImpl.isLocal((URL)object2) ? (HttpURLConnection)((URL)object2).openConnection(Proxy.NO_PROXY) : (HttpURLConnection)((URL)object2).openConnection();
        httpURLConnection.setRequestMethod(urlHttpMethod.toString());
        Properties properties2 = new Properties();
        if (properties != null) {
            properties2.putAll((Map<?, ?>)properties);
        }
        if (string3 != null && !properties2.containsKey("Authorization")) {
            httpURLConnection.addRequestProperty("Authorization", "Basic " + string3);
        }
        if (!properties2.containsKey("Accept")) {
            httpURLConnection.addRequestProperty("Accept", "*/*");
        }
        if (!properties2.containsKey("Connection")) {
            httpURLConnection.addRequestProperty("Connection", "keep-alive");
        }
        if (!properties2.containsKey("Host")) {
            httpURLConnection.addRequestProperty("Host", ((URL)object2).getHost());
        }
        if (!properties2.containsKey("Origin")) {
            httpURLConnection.addRequestProperty("Origin", ((URL)object2).getProtocol() + PROT_SEPARATOR + ((URL)object2).getHost());
        }
        for (Map.Entry<Object, Object> object3 : properties2.entrySet()) {
            httpURLConnection.addRequestProperty((String)object3.getKey(), (String)object3.getValue());
        }
        if (string4 != null) {
            httpURLConnection.setRequestProperty("Content-Length", String.valueOf(string4.getBytes(StandardCharsets.UTF_8).length));
            httpURLConnection.setDoOutput(true);
            Throwable throwable = null;
            try (OutputStream outputStream = httpURLConnection.getOutputStream();){
                outputStream.write(string4.getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        httpURLConnection.connect();
        int n2 = httpURLConnection.getResponseCode();
        String string6 = Integer.toString(n2);
        if (string6.startsWith("4") || string6.startsWith("5")) {
            if (((URL)object2).getProtocol().equals(HTTPS)) {
                UrlHttpManagerImpl.enableSslChecks();
            }
            throw new HttpError(n2, httpURLConnection.getResponseMessage(), AOUtil.getDataFromInputStream(httpURLConnection.getErrorStream()), string2);
        }
        try (InputStream inputStream = httpURLConnection.getInputStream();){
            byArray = AOUtil.getDataFromInputStream(inputStream);
        }
        if (bl && ((URL)object2).getProtocol().equals(HTTPS)) {
            UrlHttpManagerImpl.enableSslChecks();
        }
        return byArray;
    }

    public static void enableSslChecks() {
        HttpsURLConnection.setDefaultSSLSocketFactory(DEFAULT_SSL_SOCKET_FACTORY);
        HttpsURLConnection.setDefaultHostnameVerifier(DEFAULT_HOSTNAME_VERIFIER);
        LOGGER.info("Habilitadas comprobaciones SSL");
    }

    public static void setTrustManager(TrustManager[] trustManagerArray, HostnameVerifier hostnameVerifier) throws KeyManagementException, NoSuchAlgorithmException {
        KeyManager[] keyManagerArray;
        if (trustManagerArray == null || trustManagerArray.length < 1) {
            throw new IllegalArgumentException("Es necesario proporcionar al menos un TrustManager");
        }
        if (hostnameVerifier == null) {
            throw new IllegalArgumentException("Es necesario proporcionar un HostnameVerifier");
        }
        SSLContext sSLContext = SSLContext.getInstance(SSL_CONTEXT);
        try {
            keyManagerArray = UrlHttpManagerImpl.getKeyManager();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "No ha sido posible obtener el KeyManager con el KeyStore '" + System.getProperty(KEYSTORE) + "', se usara null: " + exception, exception);
            keyManagerArray = null;
        }
        sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sSLContext.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(hostnameVerifier);
    }

    public static void disableSslChecks() throws KeyManagementException, NoSuchAlgorithmException {
        UrlHttpManagerImpl.setTrustManager(DUMMY_TRUST_MANAGER, new HostnameVerifier(){

            @Override
            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        });
        LOGGER.warning("Deshabilitadas comprobaciones SSL");
    }

    private static KeyManager[] getKeyManager() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException {
        Object object;
        char[] cArray;
        KeyStore keyStore;
        if (sslKeyStore != null) {
            LOGGER.info("Se usara el almacen de claves SSL proporcionado de forma directa: " + sslKeyStore.getType());
            keyStore = sslKeyStore;
            cArray = sslKeyStorePasswordCallback != null ? sslKeyStorePasswordCallback.getPassword() : new char[]{};
        } else {
            object = System.getProperty(KEYSTORE);
            String string = System.getProperty(KEYSTORE_PASS);
            String string2 = System.getProperty(KEYSTORE_TYPE);
            if (object == null || ((String)object).isEmpty()) {
                return null;
            }
            File file = new File((String)object);
            if (!file.isFile() || !file.canRead()) {
                LOGGER.warning("El KeyStore SSL no existe o no es legible: " + file.getAbsolutePath());
                return null;
            }
            keyStore = KeyStore.getInstance(string2 != null && !string2.isEmpty() ? string2 : KEYSTORE_DEFAULT_TYPE);
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                keyStore.load(fileInputStream, string != null ? string.toCharArray() : null);
            }
            cArray = string != null ? string.toCharArray() : new char[]{};
        }
        object = KeyManagerFactory.getInstance(KEYMANAGER_INSTANCE);
        ((KeyManagerFactory)object).init(keyStore, cArray);
        return ((KeyManagerFactory)object).getKeyManagers();
    }

    static {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieHandler.setDefault(cookieManager);
        DUMMY_TRUST_MANAGER = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
            }
        }};
    }
}

