/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.core.ciphers;

public final class CipherConstants {
    private CipherConstants() {
    }

    public static enum AOCipherBlockMode {
        ECB("ECB", "Electronic CodeBook (ECB)"),
        CBC("CBC", "Cipher-Block Chaining (CBC)"),
        PCBC("PCBC", "Propagating Cipher-Block Chaining (PCBC)"),
        CTR("CTR", "Counter (CTR)"),
        CFB("CFB", "Cipher FeedBack (CFB)"),
        OFB("OFB", "Output FeedBack (OFB)");

        private String name;
        private String description;

        private AOCipherBlockMode(String string2, String string3) {
            this.name = string2;
            this.description = string3;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.description;
        }

        public static AOCipherBlockMode getValueOf(String string) {
            for (AOCipherBlockMode aOCipherBlockMode : AOCipherBlockMode.values()) {
                if (!aOCipherBlockMode.getName().equals(string)) continue;
                return aOCipherBlockMode;
            }
            return null;
        }
    }

    public static enum AOCipherPadding {
        PKCS5PADDING("PKCS5PADDING", "Relleno PKCS#5"),
        ISO10126PADDING("ISO10126PADDING", "Relleno ISO-10126"),
        NOPADDING("NOPADDING", "Sin Relleno");

        private String name;
        private String description;

        private AOCipherPadding(String string2, String string3) {
            this.name = string2;
            this.description = string3;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.description;
        }

        public static AOCipherPadding getValueOf(String string) {
            for (AOCipherPadding aOCipherPadding : AOCipherPadding.values()) {
                if (!aOCipherPadding.getName().equals(string)) continue;
                return aOCipherPadding;
            }
            return null;
        }
    }

    public static enum AOCipherAlgorithm {
        AES("AES", "Advanced Encryption Standard (AES)", false, true, "2.16.840.1.101.3.4.1"),
        BLOWFISH("Blowfish", "Blowfish", false, true, "1.3.6.1.4.1.3029.1.1.1"),
        DES("DES", "Data Encryption Standard (DES)", false, true, "1.2.840.113549.3.6"),
        TRIPLEDES("DESede", "Triple DES (3DES)", false, true, "1.2.840.113549.3.7"),
        PBEWITHMD5ANDDES("PBEWithMD5AndDES", "Contrase\u00f1a con MD5 y DES", true, false, "1.2.840.113549.1.5.3"),
        PBEWITHSHA1ANDDESEDE("PBEWithSHA1AndDESede", "Contrase\u00f1a con SHA1 y 3DES", true, false, "1.2.840.113549.1.5.10"),
        PBEWITHSHA1ANDRC2_40("PBEWithSHA1AndRC2_40", "Contrase\u00f1a con SHA1 y RC2", true, false, "1.2.840.113549.1.5.11"),
        HMACMD5("HmacMD5", "HmacMD5", false, true, "1.3.6.1.5.5.8.1.1"),
        HMACSHA1("HmacSHA1", "HmacSHA1", false, true, "1.2.840.113549.2.7"),
        HMACSHA256("HmacSHA256", "HmacSHA256", false, true, "1.2.840.113549.2.9"),
        HMACSHA384("HmacSHA384", "HmacSHA384", false, true, "1.2.840.113549.2.10"),
        HMACSHA512("HmacSHA512", "HmacSHA512", false, true, "1.2.840.113549.2.11");

        private static final AOCipherAlgorithm DEFAULT_CIPHER_ALGO;
        private String name;
        private String description;
        private boolean password;
        private boolean key;
        private String oid;

        public static AOCipherAlgorithm getDefault() {
            return DEFAULT_CIPHER_ALGO;
        }

        private AOCipherAlgorithm(String string2, String string3, boolean bl, boolean bl2, String string4) {
            this.name = string2;
            this.description = string3;
            this.password = bl;
            this.key = bl2;
            this.oid = string4;
        }

        public boolean supportsPassword() {
            return this.password;
        }

        public boolean supportsKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.description;
        }

        public String getOid() {
            return this.oid;
        }

        public static AOCipherAlgorithm getValueOf(String string) {
            for (AOCipherAlgorithm aOCipherAlgorithm : AOCipherAlgorithm.values()) {
                if (!aOCipherAlgorithm.getName().equalsIgnoreCase(string)) continue;
                return aOCipherAlgorithm;
            }
            return null;
        }

        static {
            DEFAULT_CIPHER_ALGO = AES;
        }
    }
}

