/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf.codec;

import com.aowagie.text.pdf.RandomAccessFileOrArray;
import com.aowagie.text.pdf.codec.TIFFField;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

class TIFFDirectory
implements Serializable {
    private static final long serialVersionUID = -168636766193675380L;
    private boolean isBigEndian;
    private int numEntries;
    private TIFFField[] fields;
    private final Hashtable fieldIndex = new Hashtable();
    private long IFDOffset = 8L;
    private long nextIFDOffset = 0L;
    private static final int[] sizeOfType = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    TIFFDirectory() {
    }

    private static boolean isValidEndianTag(int endian) {
        return endian == 18761 || endian == 19789;
    }

    TIFFDirectory(RandomAccessFileOrArray stream, int directory) throws IOException {
        long global_save_offset = stream.getFilePointer();
        stream.seek(0L);
        int endian = stream.readUnsignedShort();
        if (!TIFFDirectory.isValidEndianTag(endian)) {
            throw new IllegalArgumentException("Bad endianness tag (not 0x4949 or 0x4d4d).");
        }
        this.isBigEndian = endian == 19789;
        int magic = this.readUnsignedShort(stream);
        if (magic != 42) {
            throw new IllegalArgumentException("Bad magic number, should be 42.");
        }
        long ifd_offset = this.readUnsignedInt(stream);
        for (int i = 0; i < directory; ++i) {
            if (ifd_offset == 0L) {
                throw new IllegalArgumentException("Directory number too large.");
            }
            stream.seek(ifd_offset);
            int entries = this.readUnsignedShort(stream);
            stream.skip(12 * entries);
            ifd_offset = this.readUnsignedInt(stream);
        }
        stream.seek(ifd_offset);
        this.initialize(stream);
        stream.seek(global_save_offset);
    }

    private void initialize(RandomAccessFileOrArray stream) throws IOException {
        long nextTagOffset = 0L;
        long maxOffset = stream.length();
        this.IFDOffset = stream.getFilePointer();
        this.numEntries = this.readUnsignedShort(stream);
        this.fields = new TIFFField[this.numEntries];
        for (int i = 0; i < this.numEntries && nextTagOffset < maxOffset; ++i) {
            int tag = this.readUnsignedShort(stream);
            int type = this.readUnsignedShort(stream);
            int count = (int)this.readUnsignedInt(stream);
            boolean processTag = true;
            nextTagOffset = stream.getFilePointer() + 4;
            try {
                if (count * sizeOfType[type] > 4) {
                    long valueOffset = this.readUnsignedInt(stream);
                    if (valueOffset < maxOffset) {
                        stream.seek(valueOffset);
                    } else {
                        processTag = false;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException ae) {
                processTag = false;
            }
            if (processTag) {
                this.fieldIndex.put(tag, i);
                Object obj = null;
                switch (type) {
                    case 1: 
                    case 2: 
                    case 6: 
                    case 7: {
                        byte[] bvalues = new byte[count];
                        stream.readFully(bvalues, 0, count);
                        if (type == 2) {
                            int index = 0;
                            int prevIndex = 0;
                            ArrayList<String> v = new ArrayList<String>();
                            while (index < count) {
                                while (index < count && bvalues[index++] != 0) {
                                }
                                v.add(new String(bvalues, prevIndex, index - prevIndex));
                                prevIndex = index;
                            }
                            count = v.size();
                            String[] strings = new String[count];
                            for (int c = 0; c < count; ++c) {
                                strings[c] = (String)v.get(c);
                            }
                            obj = strings;
                            break;
                        }
                        obj = bvalues;
                        break;
                    }
                    case 3: {
                        int j;
                        char[] cvalues = new char[count];
                        for (j = 0; j < count; ++j) {
                            cvalues[j] = (char)this.readUnsignedShort(stream);
                        }
                        obj = cvalues;
                        break;
                    }
                    case 4: {
                        int j;
                        long[] lvalues = new long[count];
                        for (j = 0; j < count; ++j) {
                            lvalues[j] = this.readUnsignedInt(stream);
                        }
                        obj = lvalues;
                        break;
                    }
                    case 5: {
                        int j;
                        long[][] llvalues = new long[count][2];
                        for (j = 0; j < count; ++j) {
                            llvalues[j][0] = this.readUnsignedInt(stream);
                            llvalues[j][1] = this.readUnsignedInt(stream);
                        }
                        obj = llvalues;
                        break;
                    }
                    case 8: {
                        int j;
                        short[] svalues = new short[count];
                        for (j = 0; j < count; ++j) {
                            svalues[j] = this.readShort(stream);
                        }
                        obj = svalues;
                        break;
                    }
                    case 9: {
                        int j;
                        int[] ivalues = new int[count];
                        for (j = 0; j < count; ++j) {
                            ivalues[j] = this.readInt(stream);
                        }
                        obj = ivalues;
                        break;
                    }
                    case 10: {
                        int j;
                        int[][] iivalues = new int[count][2];
                        for (j = 0; j < count; ++j) {
                            iivalues[j][0] = this.readInt(stream);
                            iivalues[j][1] = this.readInt(stream);
                        }
                        obj = iivalues;
                        break;
                    }
                    case 11: {
                        int j;
                        float[] fvalues = new float[count];
                        for (j = 0; j < count; ++j) {
                            fvalues[j] = this.readFloat(stream);
                        }
                        obj = fvalues;
                        break;
                    }
                    case 12: {
                        int j;
                        double[] dvalues = new double[count];
                        for (j = 0; j < count; ++j) {
                            dvalues[j] = this.readDouble(stream);
                        }
                        obj = dvalues;
                        break;
                    }
                }
                this.fields[i] = new TIFFField(tag, type, count, obj);
            }
            stream.seek(nextTagOffset);
        }
        try {
            this.nextIFDOffset = this.readUnsignedInt(stream);
        }
        catch (Exception e) {
            this.nextIFDOffset = 0L;
        }
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    TIFFField getField(int tag) {
        Integer i = (Integer)this.fieldIndex.get(tag);
        if (i == null) {
            return null;
        }
        return this.fields[i];
    }

    boolean isTagPresent(int tag) {
        return this.fieldIndex.containsKey(tag);
    }

    public int[] getTags() {
        int[] tags = new int[this.fieldIndex.size()];
        Enumeration e = this.fieldIndex.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            tags[i++] = (Integer)e.nextElement();
        }
        return tags;
    }

    public TIFFField[] getFields() {
        return this.fields;
    }

    private byte getFieldAsByte(int tag, int index) {
        Integer i = (Integer)this.fieldIndex.get(tag);
        byte[] b = this.fields[i].getAsBytes();
        return b[index];
    }

    private long getFieldAsLong(int tag, int index) {
        Integer i = (Integer)this.fieldIndex.get(tag);
        return this.fields[i].getAsLong(index);
    }

    long getFieldAsLong(int tag) {
        return this.getFieldAsLong(tag, 0);
    }

    private float getFieldAsFloat(int tag, int index) {
        Integer i = (Integer)this.fieldIndex.get(tag);
        return this.fields[i].getAsFloat(index);
    }

    private double getFieldAsDouble(int tag, int index) {
        Integer i = (Integer)this.fieldIndex.get(tag);
        return this.fields[i].getAsDouble(index);
    }

    private short readShort(RandomAccessFileOrArray stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readShort();
        }
        return stream.readShortLE();
    }

    private int readUnsignedShort(RandomAccessFileOrArray stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readUnsignedShort();
        }
        return stream.readUnsignedShortLE();
    }

    private int readInt(RandomAccessFileOrArray stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readInt();
        }
        return stream.readIntLE();
    }

    private long readUnsignedInt(RandomAccessFileOrArray stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readUnsignedInt();
        }
        return stream.readUnsignedIntLE();
    }

    private long readLong(RandomAccessFileOrArray stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readLong();
        }
        return stream.readLongLE();
    }

    private float readFloat(RandomAccessFileOrArray stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readFloat();
        }
        return stream.readFloatLE();
    }

    private double readDouble(RandomAccessFileOrArray stream) throws IOException {
        if (this.isBigEndian) {
            return stream.readDouble();
        }
        return stream.readDoubleLE();
    }

    private static int readUnsignedShort(RandomAccessFileOrArray stream, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            return stream.readUnsignedShort();
        }
        return stream.readUnsignedShortLE();
    }

    private static long readUnsignedInt(RandomAccessFileOrArray stream, boolean isBigEndian) throws IOException {
        if (isBigEndian) {
            return stream.readUnsignedInt();
        }
        return stream.readUnsignedIntLE();
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public long getIFDOffset() {
        return this.IFDOffset;
    }

    public long getNextIFDOffset() {
        return this.nextIFDOffset;
    }
}

