/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf.codec;

import com.aowagie.text.pdf.RandomAccessFileOrArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

class JBIG2SegmentReader {
    private static final int PAGE_INFORMATION = 48;
    private static final int END_OF_PAGE = 49;
    private static final int END_OF_FILE = 51;
    private final SortedMap segments = new TreeMap();
    private final SortedMap pages = new TreeMap();
    private final SortedSet globals = new TreeSet();
    private final RandomAccessFileOrArray ra;
    private boolean sequential;
    private boolean number_of_pages_known;
    private int number_of_pages = -1;
    private boolean read = false;

    public JBIG2SegmentReader(RandomAccessFileOrArray ra) throws IOException {
        this.ra = ra;
    }

    private static byte[] copyByteArray(byte[] b) {
        byte[] bc = new byte[b.length];
        System.arraycopy(b, 0, bc, 0, b.length);
        return bc;
    }

    public void read() throws IOException {
        if (this.read) {
            throw new IllegalStateException("already attempted a read() on this Jbig2 File");
        }
        this.read = true;
        this.readFileHeader();
        if (this.sequential) {
            do {
                JBIG2Segment tmp = this.readHeader();
                this.readSegment(tmp);
                this.segments.put(tmp.segmentNumber, tmp);
            } while (this.ra.getFilePointer() < this.ra.length());
        } else {
            JBIG2Segment tmp;
            do {
                tmp = this.readHeader();
                this.segments.put(tmp.segmentNumber, tmp);
            } while (tmp.type != 51);
            Iterator segs = this.segments.keySet().iterator();
            while (segs.hasNext()) {
                this.readSegment((JBIG2Segment)this.segments.get(segs.next()));
            }
        }
    }

    private void readSegment(JBIG2Segment s) throws IOException {
        int ptr = this.ra.getFilePointer();
        if (s.dataLength == 0xFFFFFFFFL) {
            return;
        }
        byte[] data = new byte[(int)s.dataLength];
        this.ra.read(data);
        JBIG2Segment.access$502(s, data);
        if (s.type == 48) {
            int last = this.ra.getFilePointer();
            this.ra.seek(ptr);
            int page_bitmap_width = this.ra.readInt();
            int page_bitmap_height = this.ra.readInt();
            this.ra.seek(last);
            JBIG2Page p = (JBIG2Page)this.pages.get(s.page);
            if (p == null) {
                throw new IllegalStateException("referring to widht/height of page we havent seen yet? " + s.page);
            }
            p.pageBitmapWidth = page_bitmap_width;
            p.pageBitmapHeight = page_bitmap_height;
        }
    }

    private JBIG2Segment readHeader() throws IOException {
        int i;
        int ptr = this.ra.getFilePointer();
        int segment_number = this.ra.readInt();
        JBIG2Segment s = new JBIG2Segment(segment_number);
        int segment_header_flags = this.ra.read();
        boolean deferred_non_retain = (segment_header_flags & 0x80) == 128;
        s.deferredNonRetain = deferred_non_retain;
        boolean page_association_size = (segment_header_flags & 0x40) == 64;
        int segment_type = segment_header_flags & 0x3F;
        s.type = segment_type;
        int referred_to_byte0 = this.ra.read();
        int count_of_referred_to_segments = (referred_to_byte0 & 0xE0) >> 5;
        int[] referred_to_segment_numbers = null;
        boolean[] segment_retention_flags = null;
        if (count_of_referred_to_segments == 7) {
            this.ra.seek(this.ra.getFilePointer() - 1);
            count_of_referred_to_segments = this.ra.readInt() & 0x1FFFFFFF;
            segment_retention_flags = new boolean[count_of_referred_to_segments + 1];
            i = 0;
            int referred_to_current_byte = 0;
            do {
                int j;
                if ((j = i % 8) == 0) {
                    referred_to_current_byte = this.ra.read();
                }
                boolean bl = segment_retention_flags[i] = (1 << j & referred_to_current_byte) >> j == 1;
            } while (++i <= count_of_referred_to_segments);
        } else if (count_of_referred_to_segments <= 4) {
            segment_retention_flags = new boolean[count_of_referred_to_segments + 1];
            referred_to_byte0 &= 0x1F;
            for (i = 0; i <= count_of_referred_to_segments; ++i) {
                segment_retention_flags[i] = (1 << i & referred_to_byte0) >> i == 1;
            }
        } else if (count_of_referred_to_segments == 5 || count_of_referred_to_segments == 6) {
            throw new IllegalStateException("count of referred-to segments had bad value in header for segment " + segment_number + " starting at " + ptr);
        }
        JBIG2Segment.access$1102(s, segment_retention_flags);
        s.countOfReferredToSegments = count_of_referred_to_segments;
        referred_to_segment_numbers = new int[count_of_referred_to_segments + 1];
        for (i = 1; i <= count_of_referred_to_segments; ++i) {
            referred_to_segment_numbers[i] = segment_number <= 256 ? this.ra.read() : (segment_number <= 65536 ? this.ra.readUnsignedShort() : (int)this.ra.readUnsignedInt());
        }
        JBIG2Segment.access$1302(s, referred_to_segment_numbers);
        int page_association_offset = this.ra.getFilePointer() - ptr;
        int segment_page_association = page_association_size ? this.ra.readInt() : this.ra.read();
        if (segment_page_association < 0) {
            throw new IllegalStateException("page " + segment_page_association + " invalid for segment " + segment_number + " starting at " + ptr);
        }
        s.page = segment_page_association;
        s.page_association_size = page_association_size;
        s.page_association_offset = page_association_offset;
        if (segment_page_association > 0 && !this.pages.containsKey(segment_page_association)) {
            this.pages.put(segment_page_association, new JBIG2Page(segment_page_association, this));
        }
        if (segment_page_association > 0) {
            ((JBIG2Page)this.pages.get(segment_page_association)).addSegment(s);
        } else {
            this.globals.add(s);
        }
        long segment_data_length = this.ra.readUnsignedInt();
        s.dataLength = segment_data_length;
        int end_ptr = this.ra.getFilePointer();
        this.ra.seek(ptr);
        byte[] header_data = new byte[end_ptr - ptr];
        this.ra.read(header_data);
        JBIG2Segment.access$102(s, header_data);
        return s;
    }

    private void readFileHeader() throws IOException {
        this.ra.seek(0);
        byte[] idstring = new byte[8];
        this.ra.read(idstring);
        byte[] refidstring = new byte[]{-105, 74, 66, 50, 13, 10, 26, 10};
        for (int i = 0; i < idstring.length; ++i) {
            if (idstring[i] == refidstring[i]) continue;
            throw new IllegalStateException("file header idstring not good at byte " + i);
        }
        int fileheaderflags = this.ra.read();
        this.sequential = (fileheaderflags & 1) == 1;
        boolean bl = this.number_of_pages_known = (fileheaderflags & 2) == 0;
        if ((fileheaderflags & 0xFC) != 0) {
            throw new IllegalStateException("file header flags bits 2-7 not 0");
        }
        if (this.number_of_pages_known) {
            this.number_of_pages = this.ra.readInt();
        }
    }

    private int numberOfPages() {
        return this.pages.size();
    }

    JBIG2Page getPage(int page) {
        return (JBIG2Page)this.pages.get(page);
    }

    byte[] getGlobal(boolean for_embedding) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            for (JBIG2Segment s : this.globals) {
                if (for_embedding && (s.type == 51 || s.type == 49)) continue;
                os.write(s.headerData);
                os.write(s.data);
            }
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (os.size() <= 0) {
            return null;
        }
        return os.toByteArray();
    }

    public String toString() {
        if (this.read) {
            return "Jbig2SegmentReader: number of pages: " + this.numberOfPages();
        }
        return "Jbig2SegmentReader in indeterminate state.";
    }

    public static class JBIG2Page {
        private final JBIG2SegmentReader sr;
        private final SortedMap segs = new TreeMap();
        int pageBitmapWidth = -1;
        int pageBitmapHeight = -1;

        private JBIG2Page(int page, JBIG2SegmentReader sr) {
            this.sr = sr;
        }

        public byte[] getData(boolean for_embedding) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            for (Integer sn : this.segs.keySet()) {
                JBIG2Segment s = (JBIG2Segment)this.segs.get(sn);
                if (for_embedding && (s.type == 51 || s.type == 49)) continue;
                if (for_embedding) {
                    byte[] headerData_emb = JBIG2SegmentReader.copyByteArray(s.headerData);
                    if (s.page_association_size) {
                        headerData_emb[((JBIG2Segment)s).page_association_offset] = 0;
                        headerData_emb[((JBIG2Segment)s).page_association_offset + 1] = 0;
                        headerData_emb[((JBIG2Segment)s).page_association_offset + 2] = 0;
                        headerData_emb[((JBIG2Segment)s).page_association_offset + 3] = 1;
                    } else {
                        headerData_emb[((JBIG2Segment)s).page_association_offset] = 1;
                    }
                    os.write(headerData_emb);
                } else {
                    os.write(s.headerData);
                }
                os.write(s.data);
            }
            os.close();
            return os.toByteArray();
        }

        private void addSegment(JBIG2Segment s) {
            this.segs.put(s.segmentNumber, s);
        }
    }

    private static class JBIG2Segment
    implements Comparable {
        private final int segmentNumber;
        private long dataLength = -1L;
        private int page = -1;
        private int[] referredToSegmentNumbers = null;
        private boolean[] segmentRetentionFlags = null;
        private int type = -1;
        private boolean deferredNonRetain = false;
        private int countOfReferredToSegments = -1;
        private byte[] data = null;
        private byte[] headerData = null;
        private boolean page_association_size = false;
        private int page_association_offset = -1;

        private JBIG2Segment(int segment_number) {
            this.segmentNumber = segment_number;
        }

        public int compareTo(Object o) {
            return this.compareTo((JBIG2Segment)o);
        }

        private int compareTo(JBIG2Segment s) {
            return this.segmentNumber - s.segmentNumber;
        }

        static /* synthetic */ byte[] access$502(JBIG2Segment x0, byte[] x1) {
            x0.data = x1;
            return x1;
        }

        static /* synthetic */ boolean[] access$1102(JBIG2Segment x0, boolean[] x1) {
            x0.segmentRetentionFlags = x1;
            return x1;
        }

        static /* synthetic */ int[] access$1302(JBIG2Segment x0, int[] x1) {
            x0.referredToSegmentNumbers = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$102(JBIG2Segment x0, byte[] x1) {
            x0.headerData = x1;
            return x1;
        }
    }
}

