/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf;

import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfIndirectReference;
import com.aowagie.text.pdf.PdfLiteral;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfObject;
import com.aowagie.text.pdf.PdfReader;
import com.aowagie.text.pdf.PdfResources;
import java.util.HashMap;
import java.util.LinkedHashMap;

class PageResources {
    private final PdfDictionary fontDictionary = new PdfDictionary();
    private final PdfDictionary xObjectDictionary = new PdfDictionary();
    private final PdfDictionary colorDictionary = new PdfDictionary();
    private final PdfDictionary patternDictionary = new PdfDictionary();
    private final PdfDictionary shadingDictionary = new PdfDictionary();
    private final PdfDictionary extGStateDictionary = new PdfDictionary();
    private final PdfDictionary propertyDictionary = new PdfDictionary();
    private HashMap forbiddenNames;
    private PdfDictionary originalResources;
    private int[] namePtr = new int[]{0};
    private HashMap usedNames;

    PageResources() {
    }

    void setOriginalResources(PdfDictionary resources, int[] newNamePtr) {
        if (newNamePtr != null) {
            this.namePtr = newNamePtr;
        }
        this.forbiddenNames = new LinkedHashMap();
        this.usedNames = new LinkedHashMap();
        if (resources == null) {
            return;
        }
        this.originalResources = new PdfDictionary();
        this.originalResources.merge(resources);
        for (PdfName element : resources.getKeys()) {
            PdfName key = element;
            PdfObject sub = PdfReader.getPdfObject(resources.get(key));
            if (sub == null || !sub.isDictionary()) continue;
            PdfDictionary dic = (PdfDictionary)sub;
            for (PdfName element2 : dic.getKeys()) {
                this.forbiddenNames.put(element2, null);
            }
            PdfDictionary dic2 = new PdfDictionary();
            dic2.merge(dic);
            this.originalResources.put(key, dic2);
        }
    }

    private PdfName translateName(PdfName name) {
        PdfName translated = name;
        if (this.forbiddenNames != null && (translated = (PdfName)this.usedNames.get(name)) == null) {
            int n;
            do {
                n = this.namePtr[0];
                this.namePtr[0] = n + 1;
            } while (this.forbiddenNames.containsKey(translated = new PdfName("Xi" + n)));
            this.usedNames.put(name, translated);
        }
        return translated;
    }

    PdfName addFont(PdfName name, PdfIndirectReference reference) {
        name = this.translateName(name);
        this.fontDictionary.put(name, reference);
        return name;
    }

    PdfName addXObject(PdfName name, PdfIndirectReference reference) {
        name = this.translateName(name);
        this.xObjectDictionary.put(name, reference);
        return name;
    }

    PdfName addColor(PdfName name, PdfIndirectReference reference) {
        name = this.translateName(name);
        this.colorDictionary.put(name, reference);
        return name;
    }

    void addDefaultColor(PdfDictionary dic) {
        this.colorDictionary.merge(dic);
    }

    void addDefaultColorDiff(PdfDictionary dic) {
        this.colorDictionary.mergeDifferent(dic);
    }

    PdfName addShading(PdfName name, PdfIndirectReference reference) {
        name = this.translateName(name);
        this.shadingDictionary.put(name, reference);
        return name;
    }

    PdfName addPattern(PdfName name, PdfIndirectReference reference) {
        name = this.translateName(name);
        this.patternDictionary.put(name, reference);
        return name;
    }

    PdfName addExtGState(PdfName name, PdfIndirectReference reference) {
        name = this.translateName(name);
        this.extGStateDictionary.put(name, reference);
        return name;
    }

    PdfName addProperty(PdfName name, PdfIndirectReference reference) {
        name = this.translateName(name);
        this.propertyDictionary.put(name, reference);
        return name;
    }

    PdfDictionary getResources() {
        PdfResources resources = new PdfResources();
        if (this.originalResources != null) {
            resources.putAll(this.originalResources);
        }
        resources.put(PdfName.PROCSET, new PdfLiteral("[/PDF /Text /ImageB /ImageC /ImageI]"));
        resources.add(PdfName.FONT, this.fontDictionary);
        resources.add(PdfName.XOBJECT, this.xObjectDictionary);
        resources.add(PdfName.COLORSPACE, this.colorDictionary);
        resources.add(PdfName.PATTERN, this.patternDictionary);
        resources.add(PdfName.SHADING, this.shadingDictionary);
        resources.add(PdfName.EXTGSTATE, this.extGStateDictionary);
        resources.add(PdfName.PROPERTIES, this.propertyDictionary);
        return resources;
    }

    boolean hasResources() {
        return this.fontDictionary.size() > 0 || this.xObjectDictionary.size() > 0 || this.colorDictionary.size() > 0 || this.patternDictionary.size() > 0 || this.shadingDictionary.size() > 0 || this.extGStateDictionary.size() > 0 || this.propertyDictionary.size() > 0;
    }
}

