/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.sequence.SequenceModel;

class SingleByteCharsetProber
extends CharsetProber {
    static final int SAMPLE_SIZE = 64;
    static final int SB_ENOUGH_REL_THRESHOLD = 1024;
    static final float POSITIVE_SHORTCUT_THRESHOLD = 0.95f;
    static final float NEGATIVE_SHORTCUT_THRESHOLD = 0.05f;
    static final int SYMBOL_CAT_ORDER = 250;
    static final int NUMBER_OF_SEQ_CAT = 4;
    static final int POSITIVE_CAT = 3;
    static final int NEGATIVE_CAT = 0;
    private CharsetProber.ProbingState state;
    private final SequenceModel model;
    private final boolean reversed;
    private short lastOrder;
    private int totalSeqs;
    private final int[] seqCounters;
    private int totalChar;
    private int freqChar;
    private final CharsetProber nameProber;

    SingleByteCharsetProber(SequenceModel sequenceModel) {
        this.model = sequenceModel;
        this.reversed = false;
        this.nameProber = null;
        this.seqCounters = new int[4];
        this.reset();
    }

    public SingleByteCharsetProber(SequenceModel sequenceModel, boolean bl, CharsetProber charsetProber) {
        this.model = sequenceModel;
        this.reversed = bl;
        this.nameProber = charsetProber;
        this.seqCounters = new int[4];
        this.reset();
    }

    boolean keepEnglishLetters() {
        return this.model.getKeepEnglishLetter();
    }

    @Override
    public String getCharSetName() {
        if (this.nameProber == null) {
            return this.model.getCharsetName();
        }
        return this.nameProber.getCharSetName();
    }

    @Override
    public float getConfidence() {
        if (this.totalSeqs > 0) {
            float f = 1.0f * (float)this.seqCounters[3] / (float)this.totalSeqs / this.model.getTypicalPositiveRatio();
            if ((f = f * (float)this.freqChar / (float)this.totalChar) >= 1.0f) {
                f = 0.99f;
            }
            return f;
        }
        return 0.01f;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            short s = this.model.getOrder(byArray[i]);
            if (s < 250) {
                ++this.totalChar;
            }
            if (s < 64) {
                ++this.freqChar;
                if (this.lastOrder < 64) {
                    ++this.totalSeqs;
                    if (!this.reversed) {
                        byte by = this.model.getPrecedence(this.lastOrder * 64 + s);
                        this.seqCounters[by] = this.seqCounters[by] + 1;
                    } else {
                        byte by = this.model.getPrecedence(s * 64 + this.lastOrder);
                        this.seqCounters[by] = this.seqCounters[by] + 1;
                    }
                }
            }
            this.lastOrder = s;
        }
        if (this.state == CharsetProber.ProbingState.DETECTING && this.totalSeqs > 1024) {
            float f = this.getConfidence();
            if (f > 0.95f) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
            } else if (f < 0.05f) {
                this.state = CharsetProber.ProbingState.NOT_ME;
            }
        }
        return this.state;
    }

    @Override
    public void reset() {
        this.state = CharsetProber.ProbingState.DETECTING;
        this.lastOrder = (short)255;
        for (int i = 0; i < 4; ++i) {
            this.seqCounters[i] = 0;
        }
        this.totalSeqs = 0;
        this.totalChar = 0;
        this.freqChar = 0;
    }

    @Override
    public void setOption() {
    }
}

