/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.nio.ByteBuffer;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;

public class Latin1Prober
extends CharsetProber {
    static final byte UDF = 0;
    static final byte OTH = 1;
    static final byte ASC = 2;
    static final byte ASS = 3;
    static final byte ACV = 4;
    static final byte ACO = 5;
    static final byte ASV = 6;
    static final byte ASO = 7;
    static final int CLASS_NUM = 8;
    static final int FREQ_CAT_NUM = 4;
    private CharsetProber.ProbingState state;
    private byte lastCharClass;
    private final int[] freqCounter = new int[4];
    private static final byte[] latin1CharToClass = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 0, 1, 7, 1, 1, 1, 1, 1, 1, 5, 1, 5, 0, 5, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 7, 1, 7, 0, 7, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 4, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 4, 4, 4, 4, 4, 1, 4, 4, 4, 4, 4, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 6, 6, 6, 6, 6, 1, 6, 6, 6, 6, 6, 7, 7, 7};
    private static final byte[] latin1ClassModel = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 3, 3, 1, 1, 3, 3, 0, 3, 3, 3, 1, 2, 1, 2, 0, 3, 3, 3, 3, 3, 3, 3, 0, 3, 1, 3, 1, 1, 1, 3, 0, 3, 1, 3, 1, 1, 3, 3};

    public Latin1Prober() {
        this.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_WINDOWS_1252;
    }

    @Override
    public float getConfidence() {
        float f;
        if (this.state == CharsetProber.ProbingState.NOT_ME) {
            return 0.01f;
        }
        int n = 0;
        for (int i = 0; i < this.freqCounter.length; ++i) {
            n += this.freqCounter[i];
        }
        if (n <= 0) {
            f = 0.0f;
        } else {
            f = (float)this.freqCounter[3] * 1.0f / (float)n;
            f -= (float)this.freqCounter[1] * 20.0f / (float)n;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        return f *= 0.5f;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = Latin1Prober.filterWithEnglishLetters(byArray, n, n2);
        byte[] byArray2 = byteBuffer.array();
        int n3 = byteBuffer.position();
        for (int i = 0; i < n3; ++i) {
            int n4 = byArray2[i] & 0xFF;
            byte by = latin1CharToClass[n4];
            byte by2 = latin1ClassModel[this.lastCharClass * 8 + by];
            if (by2 == 0) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            byte by3 = by2;
            this.freqCounter[by3] = this.freqCounter[by3] + 1;
            this.lastCharClass = by;
        }
        return this.state;
    }

    @Override
    public void reset() {
        this.state = CharsetProber.ProbingState.DETECTING;
        this.lastCharClass = 1;
        for (int i = 0; i < this.freqCounter.length; ++i) {
            this.freqCounter[i] = 0;
        }
    }

    @Override
    public void setOption() {
    }
}

