/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;

class HebrewProber
extends CharsetProber {
    static final int FINAL_KAF = 234;
    static final int NORMAL_KAF = 235;
    static final int FINAL_MEM = 237;
    static final int NORMAL_MEM = 238;
    static final int FINAL_NUN = 239;
    static final int NORMAL_NUN = 240;
    static final int FINAL_PE = 243;
    static final int NORMAL_PE = 244;
    static final int FINAL_TSADI = 245;
    static final int NORMAL_TSADI = 246;
    static final byte SPACE = 32;
    static final int MIN_FINAL_CHAR_DISTANCE = 5;
    static final float MIN_MODEL_DISTANCE = 0.01f;
    private int finalCharLogicalScore;
    private int finalCharVisualScore;
    private byte prev;
    private byte beforePrev;
    private CharsetProber logicalProber = null;
    private CharsetProber visualProber = null;

    HebrewProber() {
        this.reset();
    }

    void setModalProbers(CharsetProber charsetProber, CharsetProber charsetProber2) {
        this.logicalProber = charsetProber;
        this.visualProber = charsetProber2;
    }

    @Override
    public String getCharSetName() {
        int n = this.finalCharLogicalScore - this.finalCharVisualScore;
        if (n >= 5) {
            return Constants.CHARSET_WINDOWS_1255;
        }
        if (n <= -5) {
            return Constants.CHARSET_ISO_8859_8;
        }
        float f = this.logicalProber.getConfidence() - this.visualProber.getConfidence();
        if (f > 0.01f) {
            return Constants.CHARSET_WINDOWS_1255;
        }
        if (f < -0.01f) {
            return Constants.CHARSET_ISO_8859_8;
        }
        if (n < 0) {
            return Constants.CHARSET_ISO_8859_8;
        }
        return Constants.CHARSET_WINDOWS_1255;
    }

    @Override
    public float getConfidence() {
        return 0.0f;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        if (this.logicalProber.getState() == CharsetProber.ProbingState.NOT_ME && this.visualProber.getState() == CharsetProber.ProbingState.NOT_ME) {
            return CharsetProber.ProbingState.NOT_ME;
        }
        return CharsetProber.ProbingState.DETECTING;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n, int n2) {
        if (this.getState() == CharsetProber.ProbingState.NOT_ME) {
            return CharsetProber.ProbingState.NOT_ME;
        }
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            byte by = byArray[i];
            if (by == 32) {
                if (this.beforePrev != 32) {
                    if (HebrewProber.isFinal(this.prev)) {
                        ++this.finalCharLogicalScore;
                    } else if (HebrewProber.isNonFinal(this.prev)) {
                        ++this.finalCharVisualScore;
                    }
                }
            } else if (this.beforePrev == 32 && HebrewProber.isFinal(this.prev) && by != 32) {
                ++this.finalCharVisualScore;
            }
            this.beforePrev = this.prev;
            this.prev = by;
        }
        return CharsetProber.ProbingState.DETECTING;
    }

    @Override
    public void reset() {
        this.finalCharLogicalScore = 0;
        this.finalCharVisualScore = 0;
        this.prev = (byte)32;
        this.beforePrev = (byte)32;
    }

    @Override
    public void setOption() {
    }

    protected static boolean isFinal(byte by) {
        int n = by & 0xFF;
        return n == 234 || n == 237 || n == 239 || n == 243 || n == 245;
    }

    protected static boolean isNonFinal(byte by) {
        int n = by & 0xFF;
        return n == 235 || n == 238 || n == 240 || n == 244;
    }
}

